package com.dokukino.genkidama;

import java.net.URL;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class XmlRpcTask implements Runnable {
	public static Log logger = LogFactory.getLog(XmlRpcTask.class);
	private URL url;
	private String method;
	@SuppressWarnings("unchecked")
	private List params;

	@SuppressWarnings("unchecked")
	public XmlRpcTask(URL url, String method, List params) {
		this.url = url;
		this.method = method;
		this.params = params;
	}

	@Override
	public void run() {
		XmlRpcClientConfigImpl conf = new XmlRpcClientConfigImpl();
		conf.setServerURL(url);
		XmlRpcClient client = new XmlRpcClient();
		client.setConfig(conf);
		try {
			client.execute(method, params);
		} catch (XmlRpcException e) {
			// TODO Auto-generated catch block
			if (logger.isErrorEnabled())
				logger.error("Error Occurs:", e);
		}
	}

}
