package waket.remote;

import java.util.List;

import net.arnx.jsonic.JSON;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import waket.remote.dto.GlobalEntriesDto;
import waket.remote.dto.GlobalRankingDto;
import waket.remote.entity.VideoAccessLog;
import waket.remote.entity.VideoInfo;
import waket.remote.service.OnlineDataService;
import waket.remote.service.VideoAccessLogService;

public class GlobalRankingCacheJsoner extends AbstractJsoner {
	public static Log logger = LogFactory
		.getLog(GlobalRankingCacheJsoner.class);

	private GlobalRankingDto globalRankingDto;
	private VideoAccessLogService videoAccessLogService;

	@Override
	public void setup() {
		{
			SingletonS2ContainerFactory
				.init();

			S2Container container = SingletonS2ContainerFactory
				.getContainer();
			globalRankingDto = (GlobalRankingDto) container
				.getComponent("globalRankingDto");

			videoAccessLogService = SingletonS2Container
				.getComponent("videoAccessLogService");
		}

		List ranking_cache_desc = videoAccessLogService
			.listRankingCache();

		globalRankingDto.videos = new VideoInfo[ranking_cache_desc
			.size()];

		for (int i = 0; i < globalRankingDto.videos.length; i++) {
			VideoInfo v = new VideoInfo();
			v.id = (((VideoAccessLog) ranking_cache_desc
				.get(i)).id)
				.toString();
			// v = ThumbInfoService.selectThumbUrl(v.id);
			globalRankingDto.videos[i] = v;
		}

	}

	@Override
	public void jsonize() {
		setDestfile("globalRankingCache");
		setJsonData(JSON
			.encode(
				globalRankingDto,
				true));

	}
}
