<?xml version="1.0" encoding="UTF-8"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.4 $
																																					-->
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output encoding="ISO-8859-1" indent="yes" method="html"/>
  <xsl:include href="common.xsl"/>
  <xsl:include href="xalan-ext.xsl"/>
  <xsl:param name="head.title">serverbydomain.title</xsl:param>
  <!-- Invoked when a query error is produced -->
  <xsl:template match="Domain" name="error">
    <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
      <xsl:for-each select="Exception">
        <tr>
          <td class="serverbydomain_domainline" colspan="5">
            <xsl:call-template name="str">
              <xsl:with-param name="id">serverbydomain.error.query</xsl:with-param>
              <xsl:with-param name="p0">
                <xsl:value-of select="@errorMsg"/>
              </xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:for-each>  
    </table>
  </xsl:template>
  <xsl:template name="domain_entry"/>
  <!-- Invoked to display each domain -->
  <xsl:template match="Domain" name="domain">
    <!-- we do not want to show MX4J basic domains in the console -->
    <!--xsl:for-each select="Domain"-->
    <xsl:for-each select="Domain[@name != 'Http' and @name != 'JMImplementation']">
      <xsl:sort data-type="text" order="ascending" select="@name"/>
      <xsl:variable name="img-onglet">
        <xsl:choose>
          <xsl:when test="position() = 1">bkgd_onglet_tit.gif</xsl:when>
          <xsl:otherwise>bkgd_onglet_tit2.gif</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="bgcolor-onglet">
        <xsl:choose>
          <xsl:when test="position() = 1">#660066</xsl:when>
          <xsl:otherwise>#FFFFFF</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
        <tr>
          <td>
            <img border="0" height="15" src="images/bkgd_onglet_left.gif"/>
          </td>
          <td align="left" bgcolor="#993399" nowrap="nowrap">
            <span class="Titre2">
              <font color="#FFFFFF">
                <b>
                  <xsl:value-of select="@name"/>
                </b>
              </font>
            </span>
          </td>
          <td>
            <img border="0" src="images/{$img-onglet}"/>
          </td>
          <td bgcolor="{$bgcolor-onglet}" width="100%"/>
        </tr>
      </table>
      <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
        <tr align="left" valign="top">
          <td bgcolor="#993399" class="Titre3black" colspan="3" width="40%">
            <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
              <b>
                <xsl:call-template name="str">
                  <xsl:with-param name="id">serverbydomain.table.title1</xsl:with-param>
                </xsl:call-template>
              </b>
            </font>
          </td>
          <td bgcolor="#993399" class="Titre3black" width="60%">
            <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
              <b>
                <xsl:call-template name="str">
                  <xsl:with-param name="id">serverbydomain.table.title2</xsl:with-param>
                </xsl:call-template>
              </b>
            </font>
          </td>
        </tr>
        <xsl:call-template name="mbean"/>
        <tr>
          <td colspan="4" height="15"/>
        </tr>
      </table>
    </xsl:for-each>
  </xsl:template>
  <!-- invoked for each mbean -->
  <xsl:template match="MBean" name="mbean">
    <xsl:for-each select="MBean">
      <xsl:sort data-type="text" order="ascending" select="@objectname"/>
      <xsl:variable name="cellcolor">
        <xsl:if test="(position() mod 2)=1">#CCCCCC</xsl:if>
        <xsl:if test="(position() mod 2)=0">#FFFFFF</xsl:if>
      </xsl:variable>
      <xsl:variable name="objectname">
        <xsl:call-template name="uri-encode">
          <xsl:with-param name="uri" select="@objectname"/>
        </xsl:call-template>
      </xsl:variable>
      <tr bgcolor="{$cellcolor}">
        <td align="left" colspan="3">
          &#160;<a href="mbean?objectname={$objectname}">
            <xsl:value-of select="@objectname"/>
          </a>
        </td>
        <td align="left">
          <xsl:value-of select="@description"/>
        </td>
      </tr>
    </xsl:for-each>
  </xsl:template>
  <!-- Main template -->
  <xsl:template match="Server">
    <html>
      <xsl:call-template name="head"/>
      <body bgcolor="#FFFFFF" leftmargin="0"
        onLoad="MM_preloadImages('images/bkgd_onglet_contact_on.gif','images/btn_top_on.gif')" text="#000000" topmargin="0">
        <xsl:call-template name="toprow">
          <xsl:with-param name="selection">server</xsl:with-param>
        </xsl:call-template>
        <xsl:variable name="query">
          <xsl:call-template name="str">
            <xsl:with-param name="id">serverbydomain.server.query</xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
          <tr bgcolor="#660066">
            <td class="titre1" height="17">&#160; <xsl:call-template name="str">
                <xsl:with-param name="id">serverbydomain.server.title</xsl:with-param>
              </xsl:call-template>
            </td>
            <td align="right" class="titre1" height="17" valign="middle">
              <img src="images/titres/tit_vue_serveur_{$request.locale}.gif"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name="domain"/>
        <xsl:call-template name="error"/>
        <xsl:call-template name="bottom"/>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
