/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.extension.jdbc.util.BindVariableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumType
extends AbstractValueType {
    private final Class<? extends Enum> enumClass;

    public EnumType(Class<? extends Enum> enumClass) {
        super(12);
        this.enumClass = enumClass;
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return this.toEnum(resultSet.getString(index));
    }

    protected Enum toEnum(String name) {
        if (name == null) {
            return null;
        }
        return Enum.valueOf(this.enumClass, name);
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return this.toEnum(resultSet.getString(columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.toEnum(cs.getString(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.toEnum(cs.getString(parameterName));
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setString(index, ((Enum)Enum.class.cast(value)).name());
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setString(parameterName, ((Enum)Enum.class.cast(value)).name());
        }
    }

    public String toText(Object value) {
        if (value == null) {
            return BindVariableUtil.nullText();
        }
        return BindVariableUtil.toText((String)((Enum)Enum.class.cast(value)).name());
    }
}

