/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.adaptor.ssl.SSLAdaptorServerSocketFactoryMBean;

public class SSLAdaptorServerSocketFactory
implements SSLAdaptorServerSocketFactoryMBean {
    private String m_keyStoreType = "JKS";
    private String m_trustStoreType = "JKS";
    private String m_keyStoreName;
    private String m_trustStoreName;
    private String m_keyStorePassword;
    private String m_trustStorePassword;
    private String m_keyManagerAlgorithm = "SunX509";
    private String m_trustManagerAlgorithm = "SunX509";
    private String m_keyManagerPassword;
    private String m_sslProtocol = "TLS";
    private SSLContext sslContext;
    private boolean m_wantClientAuth = false;
    private boolean m_needClientAuth = false;

    public static void addProvider(Provider provider) {
        Security.addProvider(provider);
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.m_wantClientAuth = wantClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.m_needClientAuth = needClientAuth;
    }

    public void setKeyStoreType(String keyStoreType) {
        if (keyStoreType == null || keyStoreType.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid KeyStore type");
        }
        this.m_keyStoreType = keyStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        if (trustStoreType == null || trustStoreType.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid TrustStore type");
        }
        this.m_trustStoreType = trustStoreType;
    }

    public void setKeyStoreName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid KeyStore name");
        }
        this.m_keyStoreName = name;
    }

    public void setTrustStoreName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid TrustStore name");
        }
        this.m_trustStoreName = name;
    }

    public void setKeyStorePassword(String password) {
        if (password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid KeyStore password");
        }
        this.m_keyStorePassword = password;
    }

    public void setTrustStorePassword(String password) {
        if (password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid TrustStore password");
        }
        this.m_trustStorePassword = password;
    }

    public void setKeyManagerAlgorithm(String algorithm) {
        if (algorithm == null || algorithm.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid KeyManager algorithm");
        }
        this.m_keyManagerAlgorithm = algorithm;
    }

    public void setTrustManagerAlgorithm(String algorithm) {
        if (algorithm == null || algorithm.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid TrustManager algorithm");
        }
        this.m_trustManagerAlgorithm = algorithm;
    }

    public void setKeyManagerPassword(String password) {
        if (password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid KeyManager password");
        }
        this.m_keyManagerPassword = password;
    }

    public void setSSLProtocol(String protocol) {
        if (protocol == null || protocol.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid SSL protocol");
        }
        this.m_sslProtocol = protocol;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public ServerSocket createServerSocket(int port, int backlog, String host) throws IOException {
        Logger logger = this.getLogger();
        try {
            if (this.sslContext == null) {
                File fle22;
                if (this.m_keyStoreName == null) {
                    throw new IOException("KeyStore file name cannot be null");
                }
                if (this.m_keyStorePassword == null) {
                    throw new IOException("KeyStore password cannot be null");
                }
                if (logger.isEnabledFor(0)) {
                    logger.trace("Creating SSLServerSocket");
                    logger.trace("\tKeyStore " + this.m_keyStoreName + ", type " + this.m_keyStoreType);
                    logger.trace("\tKeyManager algorithm is " + this.m_keyManagerAlgorithm);
                    logger.trace("\tTrustStore " + this.m_trustStoreName + ", type " + this.m_trustStoreType);
                    logger.trace("\tTrustManager algorithm is " + this.m_trustManagerAlgorithm);
                    logger.trace("\tSSL protocol version is " + this.m_sslProtocol);
                }
                KeyStore keystore = KeyStore.getInstance(this.m_keyStoreType);
                InputStream keyStoreStream = this.getClass().getClassLoader().getResourceAsStream(this.m_keyStoreName);
                if (keyStoreStream == null && (fle22 = new File(this.m_keyStoreName)).exists()) {
                    keyStoreStream = new FileInputStream(fle22);
                }
                if (keyStoreStream == null) {
                    throw new IOException("Cannot find KeyStore " + this.m_keyStoreName);
                }
                keystore.load(keyStoreStream, this.m_keyStorePassword.toCharArray());
                try {
                    keyStoreStream.close();
                }
                catch (IOException fle22) {
                    // empty catch block
                }
                KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(this.m_keyManagerAlgorithm);
                keyFactory.init(keystore, this.m_keyManagerPassword == null ? this.m_keyStorePassword.toCharArray() : this.m_keyManagerPassword.toCharArray());
                TrustManagerFactory trustFactory = null;
                if (this.m_trustStoreName != null) {
                    if (this.m_trustStorePassword == null) {
                        throw new IOException("TrustStore password cannot be null");
                    }
                    KeyStore trustStore = KeyStore.getInstance(this.m_trustStoreType);
                    InputStream trustStoreStream = this.getClass().getClassLoader().getResourceAsStream(this.m_trustStoreName);
                    if (trustStoreStream == null) {
                        File fle = new File(this.m_trustStoreName);
                        if (fle.exists()) {
                            trustStoreStream = new FileInputStream(fle);
                        }
                        if (trustStoreStream == null) {
                            throw new IOException("Cannot find TrustStore " + this.m_trustStoreName);
                        }
                    }
                    trustStore.load(trustStoreStream, this.m_trustStorePassword.toCharArray());
                    try {
                        trustStoreStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    trustFactory = TrustManagerFactory.getInstance(this.m_trustManagerAlgorithm);
                    trustFactory.init(trustStore);
                }
                this.sslContext = SSLContext.getInstance(this.m_sslProtocol);
                this.sslContext.init(keyFactory.getKeyManagers(), trustFactory == null ? null : trustFactory.getTrustManagers(), null);
            }
            SSLServerSocketFactory ssf = this.sslContext.getServerSocketFactory();
            SSLServerSocket serverSocket = (SSLServerSocket)ssf.createServerSocket(port, backlog, InetAddress.getByName(host));
            serverSocket.setWantClientAuth(this.m_wantClientAuth);
            serverSocket.setNeedClientAuth(this.m_needClientAuth);
            return serverSocket;
        }
        catch (IOException x) {
            logger.error("IOException occured during SSLContext creation", x);
            throw x;
        }
        catch (UnrecoverableKeyException x) {
            logger.error("Probably a bad key password", x);
            throw new IOException("Probably a bad key password: " + x.toString());
        }
        catch (Exception x) {
            logger.error("Unexpected exception", x);
            throw new IOException(x.toString());
        }
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }
}

