/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.dialect;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.dialect.Db2390Dialect;
import org.seasar.extension.jdbc.dialect.Db2400Dialect;
import org.seasar.extension.jdbc.dialect.Db2Dialect;
import org.seasar.extension.jdbc.dialect.DerbyDialect;
import org.seasar.extension.jdbc.dialect.FirebirdDialect;
import org.seasar.extension.jdbc.dialect.H2Dialect;
import org.seasar.extension.jdbc.dialect.HsqlDialect;
import org.seasar.extension.jdbc.dialect.InterbaseDialect;
import org.seasar.extension.jdbc.dialect.MaxdbDialect;
import org.seasar.extension.jdbc.dialect.Mssql2005Dialect;
import org.seasar.extension.jdbc.dialect.MssqlDialect;
import org.seasar.extension.jdbc.dialect.MysqlDialect;
import org.seasar.extension.jdbc.dialect.OracleDialect;
import org.seasar.extension.jdbc.dialect.Postgre81Dialect;
import org.seasar.extension.jdbc.dialect.PostgreDialect;
import org.seasar.extension.jdbc.dialect.SybaseDialect;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.Db2390GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.Db2400GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.Db2GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.DerbyGenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.FirebirdGenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.H2GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.HsqlGenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.InterbaseGenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.MaxdbGenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.Mssql2005GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.MssqlGenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.MysqlGenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.OracleGenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.Postgre81GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.PostgreGenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.StandardGenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.SybaseGenDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenDialectRegistry {
    protected static Db2390GenDialect DB2_390 = new Db2390GenDialect();
    protected static Db2400GenDialect DB2_400 = new Db2400GenDialect();
    protected static Db2GenDialect DB2 = new Db2GenDialect();
    protected static DerbyGenDialect DERBY = new DerbyGenDialect();
    protected static FirebirdGenDialect FIREBIRD = new FirebirdGenDialect();
    protected static H2GenDialect H2 = new H2GenDialect();
    protected static HsqlGenDialect HSQL = new HsqlGenDialect();
    protected static InterbaseGenDialect INTERBASE = new InterbaseGenDialect();
    protected static MaxdbGenDialect MAXDB = new MaxdbGenDialect();
    protected static Mssql2005GenDialect MSSQL_2005 = new Mssql2005GenDialect();
    protected static MssqlGenDialect MSSQL = new MssqlGenDialect();
    protected static MysqlGenDialect MYSQL = new MysqlGenDialect();
    protected static OracleGenDialect ORACLE = new OracleGenDialect();
    protected static PostgreGenDialect POSTGRE = new PostgreGenDialect();
    protected static Postgre81GenDialect POSTGRE81 = new Postgre81GenDialect();
    protected static SybaseGenDialect SYBASE = new SybaseGenDialect();
    protected static StandardGenDialect STANDARD = new StandardGenDialect();
    protected static Map<String, GenDialect> dialectMap = new ConcurrentHashMap<String, GenDialect>();

    private GenDialectRegistry() {
    }

    public static GenDialect getGenDialect(DbmsDialect dbmsDialect) {
        if (dbmsDialect == null) {
            throw new NullPointerException("dbmsDialect");
        }
        return GenDialectRegistry.getGenDialectInternal(dbmsDialect.getClass());
    }

    public static GenDialect getGenDialect(Class<? extends DbmsDialect> dbmsDialectClass) {
        if (dbmsDialectClass == null) {
            throw new NullPointerException("dbmsDialectClass");
        }
        return GenDialectRegistry.getGenDialectInternal(dbmsDialectClass);
    }

    protected static GenDialect getGenDialectInternal(Class<? extends DbmsDialect> dbmsDialectClass) {
        GenDialect dialect = dialectMap.get(dbmsDialectClass.getName());
        if (dialect != null) {
            return dialect;
        }
        return STANDARD;
    }

    public static void register(Class<? extends DbmsDialect> dbmsDialectClass, GenDialect genDialect) {
        if (dbmsDialectClass == null) {
            throw new NullPointerException("dbmsDialectClass");
        }
        if (genDialect == null) {
            throw new NullPointerException("genDialect");
        }
        dialectMap.put(dbmsDialectClass.getName(), genDialect);
    }

    public static void deregister(Class<? extends DbmsDialect> dbmsDialectClass) {
        if (dbmsDialectClass == null) {
            throw new NullPointerException("dbmsDialectClass");
        }
        dialectMap.remove(dbmsDialectClass.getName());
    }

    static {
        dialectMap.put(Db2390Dialect.class.getName(), DB2_390);
        dialectMap.put(Db2400Dialect.class.getName(), DB2_400);
        dialectMap.put(Db2Dialect.class.getName(), DB2);
        dialectMap.put(DerbyDialect.class.getName(), DERBY);
        dialectMap.put(FirebirdDialect.class.getName(), FIREBIRD);
        dialectMap.put(H2Dialect.class.getName(), H2);
        dialectMap.put(HsqlDialect.class.getName(), HSQL);
        dialectMap.put(InterbaseDialect.class.getName(), INTERBASE);
        dialectMap.put(MaxdbDialect.class.getName(), MAXDB);
        dialectMap.put(MssqlDialect.class.getName(), MSSQL);
        dialectMap.put(Mssql2005Dialect.class.getName(), MSSQL_2005);
        dialectMap.put(MysqlDialect.class.getName(), MYSQL);
        dialectMap.put(OracleDialect.class.getName(), ORACLE);
        dialectMap.put(PostgreDialect.class.getName(), POSTGRE);
        dialectMap.put(Postgre81Dialect.class.getName(), POSTGRE81);
        dialectMap.put(SybaseDialect.class.getName(), SYBASE);
    }
}

