/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.gen.desc.EntityDesc;
import org.seasar.extension.jdbc.gen.desc.EntityDescFactory;
import org.seasar.extension.jdbc.gen.desc.EntitySetDesc;
import org.seasar.extension.jdbc.gen.desc.EntitySetDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.desc.AssociationResolver;
import org.seasar.extension.jdbc.gen.internal.desc.AttributeDescFactoryImpl;
import org.seasar.extension.jdbc.gen.internal.desc.CompositeUniqueConstraintDescFactoryImpl;
import org.seasar.extension.jdbc.gen.internal.desc.EntityDescFactoryImpl;
import org.seasar.extension.jdbc.gen.internal.desc.PluralFormDictinary;
import org.seasar.extension.jdbc.gen.meta.DbForeignKeyMeta;
import org.seasar.extension.jdbc.gen.meta.DbTableMeta;
import org.seasar.extension.jdbc.gen.meta.DbTableMetaReader;
import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.exception.IORuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySetDescFactoryImpl
implements EntitySetDescFactory {
    protected DbTableMetaReader dbTableMetaReader;
    protected PersistenceConvention persistenceConvention;
    protected GenDialect dialect;
    protected String versionColumnNamePattern;
    protected File pluralFormFile;
    protected GenerationType generationType;
    protected Integer initialValue;
    protected Integer allocationSize;
    protected EntityDescFactory entityDescFactory;

    public EntitySetDescFactoryImpl(DbTableMetaReader dbTableMetaReader, PersistenceConvention persistenceConvention, GenDialect dialect, String versionColumnNamePattern, File pluralFormFile, GenerationType generationType, Integer initialValue, Integer allocationSize) {
        if (dbTableMetaReader == null) {
            throw new NullPointerException("dbTableMetaReader");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (persistenceConvention == null) {
            throw new NullPointerException("persistenceConvention");
        }
        if (versionColumnNamePattern == null) {
            throw new NullPointerException("versionColumnNamePattern");
        }
        this.dbTableMetaReader = dbTableMetaReader;
        this.dialect = dialect;
        this.persistenceConvention = persistenceConvention;
        this.versionColumnNamePattern = versionColumnNamePattern;
        this.pluralFormFile = pluralFormFile;
        this.generationType = generationType;
        this.initialValue = initialValue;
        this.allocationSize = allocationSize;
        this.entityDescFactory = this.createEntityDescFactory();
    }

    @Override
    public EntitySetDesc getEntitySetDesc() {
        EntitySetDesc entitySetDesc = new EntitySetDesc();
        List<DbTableMeta> dbTableMetaList = this.dbTableMetaReader.read();
        for (DbTableMeta tableMeta : dbTableMetaList) {
            EntityDesc entityDesc = this.entityDescFactory.getEntityDesc(tableMeta);
            entitySetDesc.addEntityDesc(entityDesc);
        }
        PluralFormDictinary pluralFormDictinary = this.createPluralFormDictinary();
        AssociationResolver associationResolver = this.createAssociationResolver(entitySetDesc, pluralFormDictinary);
        for (DbTableMeta tableMeta : dbTableMetaList) {
            for (DbForeignKeyMeta fkMeta : tableMeta.getForeignKeyMetaList()) {
                associationResolver.resolve(tableMeta, fkMeta);
            }
        }
        return entitySetDesc;
    }

    protected EntityDescFactory createEntityDescFactory() {
        AttributeDescFactoryImpl attributeDescFactory = new AttributeDescFactoryImpl(this.persistenceConvention, this.dialect, this.versionColumnNamePattern, this.generationType, this.initialValue, this.allocationSize);
        CompositeUniqueConstraintDescFactoryImpl compositeUniqueConstraintDescFactory = new CompositeUniqueConstraintDescFactoryImpl();
        return new EntityDescFactoryImpl(this.persistenceConvention, attributeDescFactory, compositeUniqueConstraintDescFactory);
    }

    protected AssociationResolver createAssociationResolver(EntitySetDesc entitySetDesc, PluralFormDictinary pluralFormDictinary) {
        return new AssociationResolver(entitySetDesc, pluralFormDictinary, this.persistenceConvention);
    }

    protected PluralFormDictinary createPluralFormDictinary() {
        if (this.pluralFormFile != null) {
            LinkedHashMap<String, String> map = this.loadPluralFormFile();
            return new PluralFormDictinary(map);
        }
        return new PluralFormDictinary();
    }

    public LinkedHashMap<String, String> loadPluralFormFile() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.pluralFormFile), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                int pos;
                char firstChar;
                if (line.length() == 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!' || (pos = line.indexOf(61)) < 0) continue;
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1, line.length());
                map.put(key, value);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return map;
    }
}

