/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.dialect;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.StandardGenDialect;
import org.seasar.extension.jdbc.gen.internal.sqltype.BigIntType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BinaryType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BlobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BooleanType;
import org.seasar.extension.jdbc.gen.internal.sqltype.ClobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DecimalType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DoubleType;
import org.seasar.extension.jdbc.gen.internal.sqltype.IntegerType;
import org.seasar.extension.jdbc.gen.internal.sqltype.SmallIntType;
import org.seasar.extension.jdbc.gen.internal.sqltype.TimeType;
import org.seasar.extension.jdbc.gen.internal.sqltype.VarcharType;
import org.seasar.extension.jdbc.gen.internal.util.CharUtil;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleGenDialect
extends StandardGenDialect {
    protected static int TABLE_NOT_FOUND_ERROR_CODE = 942;
    protected static int COLUMN_NOT_FOUND_ERROR_CODE = 904;
    protected static int SEQUENCE_NOT_FOUND_ERROR_CODE = 2289;

    public OracleGenDialect() {
        this.sqlTypeMap.put(-2, new BinaryType("raw($l)"));
        this.sqlTypeMap.put(-5, new BigIntType("number($p,0)"));
        this.sqlTypeMap.put(2004, new BlobType("blob"));
        this.sqlTypeMap.put(16, new BooleanType("number(1,0)"));
        this.sqlTypeMap.put(2005, new ClobType("clob"));
        this.sqlTypeMap.put(3, new DecimalType("number($p,$s)"));
        this.sqlTypeMap.put(8, new DoubleType("double precision"));
        this.sqlTypeMap.put(4, new IntegerType("number($p,0)"));
        this.sqlTypeMap.put(5, new SmallIntType("number($p,0)"));
        this.sqlTypeMap.put(92, new TimeType("date"));
        this.sqlTypeMap.put(12, new VarcharType("varchar2($l)"));
        this.columnTypeMap.put("binary_double", OracleColumnType.BINARY_DOUBLE);
        this.columnTypeMap.put("binary_float", OracleColumnType.BINARY_FLOAT);
        this.columnTypeMap.put("blob", OracleColumnType.BLOB);
        this.columnTypeMap.put("clob", OracleColumnType.CLOB);
        this.columnTypeMap.put("long", OracleColumnType.LONG);
        this.columnTypeMap.put("long raw", OracleColumnType.LONG_RAW);
        this.columnTypeMap.put("nchar", OracleColumnType.NCHAR);
        this.columnTypeMap.put("nclob", OracleColumnType.NCLOB);
        this.columnTypeMap.put("number", OracleColumnType.NUMBER);
        this.columnTypeMap.put("nvarchar2", OracleColumnType.NVARCHAR2);
        this.columnTypeMap.put("raw", OracleColumnType.RAW);
        this.columnTypeMap.put("timestamp", OracleColumnType.TIMESTAMP);
        this.columnTypeMap.put("varchar2", OracleColumnType.VARCHAR2);
    }

    @Override
    public String getName() {
        return "oracle";
    }

    @Override
    public GenerationType getDefaultGenerationType() {
        return GenerationType.SEQUENCE;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsGetIndexInfo(String catalogName, String schemaName, String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName");
        }
        for (int i = 0; i < tableName.length(); ++i) {
            if (CharUtil.isAscii(tableName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getSequenceDefinitionFragment(String dataType, long initialValue, int allocationSize) {
        return "increment by " + allocationSize + " start with " + initialValue;
    }

    @Override
    public String getSqlBlockDelimiter() {
        return "/";
    }

    @Override
    public boolean isTableNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == TABLE_NOT_FOUND_ERROR_CODE;
    }

    @Override
    public boolean isColumnNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == COLUMN_NOT_FOUND_ERROR_CODE;
    }

    @Override
    public boolean isSequenceNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == SEQUENCE_NOT_FOUND_ERROR_CODE;
    }

    @Override
    public GenDialect.ColumnType getColumnType(String typeName, int sqlType) {
        GenDialect.ColumnType columnType = (GenDialect.ColumnType)this.columnTypeMap.get(typeName);
        if (columnType != null) {
            return columnType;
        }
        if (StringUtil.startsWithIgnoreCase((String)typeName, (String)"timestamp")) {
            typeName = "timestamp";
        }
        return super.getColumnType(typeName, sqlType);
    }

    @Override
    public GenDialect.SqlBlockContext createSqlBlockContext() {
        return new OracleSqlBlockContext();
    }

    @Override
    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return "select " + sequenceName + ".nextval from dual";
    }

    @Override
    public boolean supportsCommentInCreateTable() {
        return false;
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean isJdbcCommentAvailable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableComment(Connection connection, String catalogName, String schemaName, String tableName) throws SQLException {
        String sql = "select comments from all_tab_comments where owner = ? and table_name = ? and table_type = 'TABLE'";
        logger.debug((Object)String.format(sql.replace("?", "'%s'"), schemaName, tableName));
        PreparedStatement ps = ConnectionUtil.prepareStatement((Connection)connection, (String)sql);
        try {
            ResultSet rs;
            block8: {
                String string;
                ps.setString(1, schemaName);
                ps.setString(2, tableName);
                rs = PreparedStatementUtil.executeQuery((PreparedStatement)ps);
                try {
                    if (!rs.next()) break block8;
                    string = rs.getString(1);
                }
                catch (Throwable throwable) {
                    ResultSetUtil.close((ResultSet)rs);
                    throw throwable;
                }
                ResultSetUtil.close((ResultSet)rs);
                return string;
            }
            String string = null;
            ResultSetUtil.close((ResultSet)rs);
            return string;
        }
        finally {
            StatementUtil.close((Statement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getColumnCommentMap(Connection connection, String catalogName, String schemaName, String tableName) throws SQLException {
        String sql = "select column_name, comments from all_col_comments where owner = ? and table_name = ?";
        logger.debug((Object)String.format(sql.replace("?", "'%s'"), schemaName, tableName));
        PreparedStatement ps = ConnectionUtil.prepareStatement((Connection)connection, (String)sql);
        try {
            CaseInsensitiveMap caseInsensitiveMap;
            ps.setString(1, schemaName);
            ps.setString(2, tableName);
            ResultSet rs = PreparedStatementUtil.executeQuery((PreparedStatement)ps);
            try {
                CaseInsensitiveMap commentMap = new CaseInsensitiveMap();
                while (rs.next()) {
                    commentMap.put(rs.getString(1), rs.getString(2));
                }
                caseInsensitiveMap = commentMap;
            }
            catch (Throwable throwable) {
                ResultSetUtil.close((ResultSet)rs);
                throw throwable;
            }
            ResultSetUtil.close((ResultSet)rs);
            return caseInsensitiveMap;
        }
        finally {
            StatementUtil.close((Statement)ps);
        }
    }

    @Override
    public boolean supportsReferentialUpdateRule() {
        return false;
    }

    public static class OracleSqlBlockContext
    extends StandardGenDialect.StandardSqlBlockContext {
        protected OracleSqlBlockContext() {
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "or", "replace", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "or", "replace", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "or", "replace", "triger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("declare"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("begin"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OracleColumnType
    extends StandardGenDialect.StandardColumnType {
        private static OracleColumnType BINARY_DOUBLE = new OracleColumnType("binary_double", Double.class);
        private static OracleColumnType BINARY_FLOAT = new OracleColumnType("binary_float", Float.class);
        private static OracleColumnType BLOB = new OracleColumnType("blob", byte[].class, true);
        private static OracleColumnType CLOB = new OracleColumnType("clob", String.class, true);
        private static OracleColumnType LONG_RAW = new OracleColumnType("long raw", byte[].class);
        private static OracleColumnType LONG = new OracleColumnType("long", String.class);
        private static OracleColumnType NCHAR = new OracleColumnType("nchar($l)", (Class)String.class){

            public String getColumnDefinition(int length, int precision, int scale, String defaultValue) {
                return super.getColumnDefinition(length / 2, precision, scale, defaultValue);
            }
        };
        private static OracleColumnType NCLOB = new OracleColumnType("nclob", String.class, true);
        private static OracleColumnType NUMBER = new OracleColumnType("number($p,$s)", (Class)BigDecimal.class){

            @Override
            public Class<?> getAttributeClass(int length, int precision, int scale) {
                if (scale != 0) {
                    return BigDecimal.class;
                }
                if (precision < 5) {
                    return Short.class;
                }
                if (precision < 10) {
                    return Integer.class;
                }
                if (precision < 19) {
                    return Long.class;
                }
                return BigInteger.class;
            }
        };
        private static OracleColumnType NVARCHAR2 = new OracleColumnType("nvarchar2($l)", (Class)String.class){

            public String getColumnDefinition(int length, int precision, int scale, String defaultValue) {
                return super.getColumnDefinition(length / 2, precision, scale, defaultValue);
            }
        };
        private static OracleColumnType RAW = new OracleColumnType("raw($l)", byte[].class);
        private static OracleColumnType TIMESTAMP = new OracleColumnType("timestamp($s)", Timestamp.class);
        private static OracleColumnType VARCHAR2 = new OracleColumnType("varchar2($l)", String.class);

        public OracleColumnType(String dataType, Class<?> attributeClass) {
            super(dataType, attributeClass);
        }

        public OracleColumnType(String dataType, Class<?> attributeClass, boolean lob) {
            super(dataType, attributeClass, lob);
        }
    }
}

