/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.dialect;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.dialect.PostgreDialect;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.StandardGenDialect;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BigIntType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BinaryType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BooleanType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DecimalType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DoubleType;
import org.seasar.extension.jdbc.gen.internal.sqltype.FloatType;
import org.seasar.extension.jdbc.gen.internal.sqltype.IntegerType;
import org.seasar.extension.jdbc.gen.internal.sqltype.VarcharType;
import org.seasar.extension.jdbc.gen.provider.ValueTypeProvider;
import org.seasar.extension.jdbc.gen.sqltype.SqlType;
import org.seasar.framework.util.Base64Util;

public class PostgreGenDialect
extends StandardGenDialect {
    protected static String TABLE_NOT_FOUND_SQL_STATE = "42P01";
    protected static String COLUMN_NOT_FOUND_SQL_STATE = "42703";
    protected static String SEQUENCE_NOT_FOUND_SQL_STATE = "42P01";

    public PostgreGenDialect() {
        this.sqlTypeMap.put(-5, new BigIntType(){

            public String getDataType(int length, int precision, int scale, boolean identity) {
                return identity ? "bigserial" : "bigint";
            }
        });
        this.sqlTypeMap.put(-2, new BinaryType("bytea"));
        this.sqlTypeMap.put(16, new BooleanType("bool"));
        this.sqlTypeMap.put(2004, new PostgreBlobType("oid"));
        this.sqlTypeMap.put(2005, new VarcharType("text"));
        this.sqlTypeMap.put(3, new DecimalType("decimal($p,$s)"));
        this.sqlTypeMap.put(8, new DoubleType("float8"));
        this.sqlTypeMap.put(6, new FloatType("float4"));
        this.sqlTypeMap.put(4, new IntegerType(){

            public String getDataType(int length, int precision, int scale, boolean identity) {
                return identity ? "serial" : "integer";
            }
        });
        this.columnTypeMap.put("bigint", PostgreColumnType.BIGINT);
        this.columnTypeMap.put("bigserial", PostgreColumnType.BIGSERIAL);
        this.columnTypeMap.put("bit", PostgreColumnType.BIT);
        this.columnTypeMap.put("bool", PostgreColumnType.BOOL);
        this.columnTypeMap.put("bpchar", PostgreColumnType.BPCHAR);
        this.columnTypeMap.put("bytea", PostgreColumnType.BYTEA);
        this.columnTypeMap.put("float4", PostgreColumnType.FLOAT4);
        this.columnTypeMap.put("float8", PostgreColumnType.FLOAT8);
        this.columnTypeMap.put("int2", PostgreColumnType.INT2);
        this.columnTypeMap.put("int4", PostgreColumnType.INT4);
        this.columnTypeMap.put("int8", PostgreColumnType.INT8);
        this.columnTypeMap.put("money", PostgreColumnType.MONEY);
        this.columnTypeMap.put("numeric", PostgreColumnType.NUMERIC);
        this.columnTypeMap.put("oid", PostgreColumnType.OID);
        this.columnTypeMap.put("serial", PostgreColumnType.SERIAL);
        this.columnTypeMap.put("text", PostgreColumnType.TEXT);
        this.columnTypeMap.put("timestamptz", PostgreColumnType.TIMESTAMPTZ);
        this.columnTypeMap.put("timetz", PostgreColumnType.TIMETZ);
        this.columnTypeMap.put("varbit", PostgreColumnType.VARBIT);
        this.columnTypeMap.put("varchar", PostgreColumnType.VARCHAR);
    }

    public String getName() {
        return "postgre";
    }

    public SqlType getSqlType(ValueTypeProvider valueTypeProvider, PropertyMeta propertyMeta) {
        if (propertyMeta.isLob() && propertyMeta.getPropertyClass() == String.class) {
            return this.getSqlTypeInternal(2005);
        }
        ValueType valueType = valueTypeProvider.provide(propertyMeta);
        return this.getSqlTypeInternal(valueType.getSqlType());
    }

    public String getDefaultSchemaName(String userName) {
        return null;
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    public boolean supportsSequence() {
        return true;
    }

    public String getSequenceDefinitionFragment(String dataType, long initialValue, int allocationSize) {
        return "increment by " + allocationSize + " start with " + initialValue;
    }

    public String getIdentityColumnDefinition() {
        return "not null";
    }

    public boolean isTableNotFound(Throwable throwable) {
        String sqlState = this.getSQLState(throwable);
        return TABLE_NOT_FOUND_SQL_STATE.equals(sqlState);
    }

    public boolean isColumnNotFound(Throwable throwable) {
        String sqlState = this.getSQLState(throwable);
        return COLUMN_NOT_FOUND_SQL_STATE.equals(sqlState);
    }

    public boolean isSequenceNotFound(Throwable throwable) {
        String sqlState = this.getSQLState(throwable);
        return SEQUENCE_NOT_FOUND_SQL_STATE.equals(sqlState);
    }

    public GenDialect.SqlBlockContext createSqlBlockContext() {
        return new PostgreSqlBlockContext();
    }

    public boolean supportsIdentityInsert() {
        return true;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return "select nextval('" + sequenceName + "')";
    }

    public boolean supportsCommentInCreateTable() {
        return false;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public static class PostgreBlobType
    extends AbstractSqlType {
        protected static byte[] EMPTY_BYTES = new byte[0];

        public PostgreBlobType(String dataType) {
            super(dataType);
        }

        public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
            if (value == null) {
                ps.setNull(index, 2004);
            } else if (value.length() == 0) {
                ps.setBlob(index, (Blob)new PostgreDialect.BlobImpl(EMPTY_BYTES));
            } else {
                byte[] bytes = Base64Util.decode((String)value);
                ps.setBlob(index, (Blob)new PostgreDialect.BlobImpl(bytes));
            }
        }

        public String getValue(ResultSet resultSet, int index) throws SQLException {
            Blob blob = resultSet.getBlob(index);
            if (blob == null) {
                return null;
            }
            long length = blob.length();
            if (length == 0L) {
                return Base64Util.encode((byte[])EMPTY_BYTES);
            }
            if (length > Integer.MAX_VALUE) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return Base64Util.encode((byte[])blob.getBytes(1L, (int)length));
        }
    }

    public static class PostgreSqlBlockContext
    implements GenDialect.SqlBlockContext {
        protected boolean inSqlBlock;

        public void addKeyword(String keyword) {
            if ("$$".equals(keyword)) {
                this.inSqlBlock = !this.inSqlBlock;
            }
        }

        public boolean isInSqlBlock() {
            return this.inSqlBlock;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PostgreColumnType
    extends StandardGenDialect.StandardColumnType {
        private static PostgreColumnType BIT = new PostgreColumnType("bit($l)", byte[].class);
        private static PostgreColumnType BOOL = new PostgreColumnType("bool", Boolean.class);
        private static PostgreColumnType INT8 = new PostgreColumnType("int8", Long.class);
        private static PostgreColumnType BIGSERIAL = new PostgreColumnType("bigserial", Long.class);
        private static PostgreColumnType BIGINT = new PostgreColumnType("oid", byte[].class, true);
        private static PostgreColumnType BYTEA = new PostgreColumnType("bytea", byte[].class);
        private static PostgreColumnType BPCHAR = new PostgreColumnType("char($l)", String.class);
        private static PostgreColumnType NUMERIC = new PostgreColumnType("decimal($p,$s)", (Class)BigDecimal.class){

            public String getColumnDefinition(int length, int precision, int scale, String defaultValue) {
                precision = precision > 1000 ? 1000 : precision;
                return super.getColumnDefinition(length, precision, scale, defaultValue);
            }
        };
        private static PostgreColumnType INT4 = new PostgreColumnType("int4", Integer.class);
        private static PostgreColumnType SERIAL = new PostgreColumnType("serial", Integer.class);
        private static PostgreColumnType INT2 = new PostgreColumnType("int2", Short.class);
        private static PostgreColumnType FLOAT4 = new PostgreColumnType("float4", Float.class);
        private static PostgreColumnType FLOAT8 = new PostgreColumnType("float8", Double.class);
        private static PostgreColumnType MONEY = new PostgreColumnType("money", Float.class);
        private static PostgreColumnType OID = new PostgreColumnType("oid", byte[].class, true);
        private static PostgreColumnType TEXT = new PostgreColumnType("text", String.class, true);
        private static PostgreColumnType TIMETZ = new PostgreColumnType("timetz", Time.class);
        private static PostgreColumnType TIMESTAMPTZ = new PostgreColumnType("timestamptz", Timestamp.class);
        private static PostgreColumnType VARBIT = new PostgreColumnType("varbit", byte[].class);
        private static PostgreColumnType VARCHAR = new PostgreColumnType("varchar($l)", (Class)String.class){

            public String getColumnDefinition(int length, int precision, int scale, String defaultValue) {
                length = length > 0xA00000 ? 0xA00000 : length;
                return super.getColumnDefinition(length, precision, scale, defaultValue);
            }
        };

        public PostgreColumnType(String dataType, Class<?> attributeClass) {
            super(dataType, attributeClass);
        }

        public PostgreColumnType(String dataType, Class<?> attributeClass, boolean lob) {
            super(dataType, attributeClass, lob);
        }
    }
}

