/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.DoubleConversionUtil;
import org.seasar.framework.util.StringConversionUtil;

public class DoubleType
extends AbstractSqlType {
    public DoubleType() {
        this("double");
    }

    public DoubleType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 8);
        } else {
            ps.setDouble(index, DoubleConversionUtil.toPrimitiveDouble((Object)value));
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        Double value = resultSet.getDouble(index);
        return value != null ? StringConversionUtil.toString((Object)value) : null;
    }
}

