/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class DefaultExcludesFilenameFilter
implements FilenameFilter {
    protected static String defaultFilterRegex = "^(.*~|#.*#|\\.#.*|%.*%|\\._.*|CVS|\\.cvsignore|SCCS|vssver\\.scc|\\.svn|\\.DS_Store)$";
    protected static Pattern filterPattern;

    public static void resetFilterPattern() {
        filterPattern = Pattern.compile(defaultFilterRegex);
    }

    public static void setFilterRegex(String filterRegex) {
        filterPattern = Pattern.compile(filterRegex);
    }

    public boolean accept(File dir, String name) {
        return !filterPattern.matcher(name).matches();
    }

    static {
        DefaultExcludesFilenameFilter.resetFilterPattern();
    }
}

