/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;

public class NotificationListenerMBeanServerInterceptor
extends DefaultMBeanServerInterceptor {
    public String getType() {
        return "notificationlistener";
    }

    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this.isEnabled()) {
            ListenerWrapper wrapper = new ListenerWrapper(listener, metadata.getObjectName());
            super.addNotificationListener(metadata, wrapper, filter, handback);
        } else {
            super.addNotificationListener(metadata, listener, filter, handback);
        }
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener) throws ListenerNotFoundException {
        if (this.isEnabled()) {
            ListenerWrapper wrapper = new ListenerWrapper(listener, metadata.getObjectName());
            super.removeNotificationListener(metadata, wrapper);
        } else {
            super.removeNotificationListener(metadata, listener);
        }
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (this.isEnabled()) {
            ListenerWrapper wrapper = new ListenerWrapper(listener, metadata.getObjectName());
            super.removeNotificationListener(metadata, wrapper, filter, handback);
        } else {
            super.removeNotificationListener(metadata, listener, filter, handback);
        }
    }

    private static class ListenerWrapper
    implements NotificationListener {
        private final NotificationListener listener;
        private final ObjectName objectName;

        private ListenerWrapper(NotificationListener listener, ObjectName name) {
            this.listener = listener;
            this.objectName = name;
        }

        public void handleNotification(Notification notification, Object handback) {
            Object src = notification.getSource();
            if (!(src instanceof ObjectName)) {
                notification.setSource(this.objectName);
            }
            NotificationListener listener = this.getTargetListener();
            listener.handleNotification(notification, handback);
        }

        private NotificationListener getTargetListener() {
            return this.listener;
        }

        public int hashCode() {
            return this.getTargetListener().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            try {
                ListenerWrapper other = (ListenerWrapper)obj;
                return this.getTargetListener().equals(other.getTargetListener());
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public String toString() {
            return this.getTargetListener().toString();
        }
    }
}

