/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.PrintStream;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.TcpServer;
import org.h2.server.ftp.FtpServer;
import org.h2.server.pg.PgServer;
import org.h2.server.web.WebServer;
import org.h2.util.StartBrowser;

public class Server
implements Runnable,
ShutdownHandler {
    private Service service;
    private static final int EXIT_ERROR = 1;
    private Server web;
    private Server tcp;
    private Server pg;
    private Server ftp;
    private ShutdownHandler shutdownHandler;

    private void showUsage(String a, PrintStream out) {
        if (a != null) {
            out.println("Unsupported option: " + a);
            out.println();
        }
        out.println("Starts H2 Servers");
        out.println("By default, -tcp, -web, -browser and -pg are started. Options are case sensitive.");
        out.println("java " + this.getClass().getName());
        out.println("-web                  Start the Web Server and H2 Console");
        out.println("-webAllowOthers       Allow other computers to connect");
        out.println("-webPort <port>       The port (default: 8082)");
        out.println("-webSSL               Use encrypted HTTPS connections");
        out.println("-browser              Start a browser to connect to the H2 Console");
        out.println("-tcp                  Start the TCP Server");
        out.println("-tcpAllowOthers       Allow other computers to connect");
        out.println("-tcpPort <port>       The port (default: 9092)");
        out.println("-tcpSSL               Use encrypted SSL connections");
        out.println("-tcpPassword <pass>   The password for shutting down a TCP Server");
        out.println("-tcpShutdown <url>    Shutdown the TCP Server; example: tcp://localhost:9094");
        out.println("-tcpShutdownForce     Don't wait for other connections to close");
        out.println("-pg                   Start the PG Server");
        out.println("-pgAllowOthers        Allow other computers to connect");
        out.println("-pgPort <port>        The port (default: 5435)");
        out.println("-ftp                  Start the FTP Server");
        out.println("-ftpPort <port>       The port (default: 8021)");
        out.println("-ftpDir <dir>         The base directory (default: ftp)");
        out.println("-ftpRead <user>       The user name for reading (default: guest)");
        out.println("-ftpWrite <user>      The user name for writing (default: sa)");
        out.println("-ftpWritePassword <p> The write password (default: sa)");
        out.println("-baseDir <dir>        The base directory for H2 databases; for all servers");
        out.println("-ifExists             Only existing databases may be opened; for all servers");
        out.println("-trace                Print additional trace information; for all servers");
        out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public Server() {
    }

    public static void main(String[] args) throws SQLException {
        int exitCode = new Server().run(args, System.out);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public int run(String[] args, PrintStream out) throws SQLException {
        boolean tcpStart = false;
        boolean pgStart = false;
        boolean webStart = false;
        boolean ftpStart = false;
        boolean browserStart = false;
        boolean tcpShutdown = false;
        boolean tcpShutdownForce = false;
        String tcpPassword = "";
        String tcpShutdownServer = "";
        boolean startDefaultServers = true;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            if ("-?".equals(arg) || "-help".equals(arg)) {
                this.showUsage(null, out);
                return 1;
            }
            if (arg.startsWith("-web")) {
                if ("-web".equals(arg)) {
                    startDefaultServers = false;
                    webStart = true;
                    continue;
                }
                if ("-webAllowOthers".equals(arg)) {
                    if (Server.readArgBoolean(args, i) == 0) continue;
                    ++i;
                    continue;
                }
                if ("-webSSL".equals(arg)) {
                    if (Server.readArgBoolean(args, i) == 0) continue;
                    ++i;
                    continue;
                }
                if ("-webPort".equals(arg)) {
                    ++i;
                    continue;
                }
                if ("-webScript".equals(arg)) {
                    ++i;
                    continue;
                }
                this.showUsage(arg, out);
                return 1;
            }
            if ("-browser".equals(arg)) {
                startDefaultServers = false;
                browserStart = true;
                continue;
            }
            if (arg.startsWith("-tcp")) {
                if ("-tcp".equals(arg)) {
                    startDefaultServers = false;
                    tcpStart = true;
                    continue;
                }
                if ("-tcpAllowOthers".equals(arg)) {
                    if (Server.readArgBoolean(args, i) == 0) continue;
                    ++i;
                    continue;
                }
                if ("-tcpSSL".equals(arg)) {
                    if (Server.readArgBoolean(args, i) == 0) continue;
                    ++i;
                    continue;
                }
                if ("-tcpPort".equals(arg)) {
                    ++i;
                    continue;
                }
                if ("-tcpPassword".equals(arg)) {
                    tcpPassword = args[++i];
                    continue;
                }
                if ("-tcpShutdown".equals(arg)) {
                    startDefaultServers = false;
                    tcpShutdown = true;
                    tcpShutdownServer = args[++i];
                    continue;
                }
                if ("-tcpShutdownForce".equals(arg)) {
                    if (Server.readArgBoolean(args, i) != 0) {
                        tcpShutdownForce = Server.readArgBoolean(args, i) == 1;
                        ++i;
                        continue;
                    }
                    tcpShutdownForce = true;
                    continue;
                }
                this.showUsage(arg, out);
                return 1;
            }
            if (arg.startsWith("-pg")) {
                if ("-pg".equals(arg)) {
                    startDefaultServers = false;
                    pgStart = true;
                    continue;
                }
                if ("-pgAllowOthers".equals(arg)) {
                    if (Server.readArgBoolean(args, i) == 0) continue;
                    ++i;
                    continue;
                }
                if ("-pgPort".equals(arg)) {
                    ++i;
                    continue;
                }
                this.showUsage(arg, out);
                return 1;
            }
            if (arg.startsWith("-ftp")) {
                if ("-ftp".equals(arg)) {
                    startDefaultServers = false;
                    ftpStart = true;
                    continue;
                }
                if ("-ftpPort".equals(arg)) {
                    ++i;
                    continue;
                }
                if ("-ftpDir".equals(arg)) {
                    ++i;
                    continue;
                }
                if ("-ftpRead".equals(arg)) {
                    ++i;
                    continue;
                }
                if ("-ftpWrite".equals(arg)) {
                    ++i;
                    continue;
                }
                if ("-ftpWritePassword".equals(arg)) {
                    ++i;
                    continue;
                }
                if ("-ftpTask".equals(arg)) continue;
                this.showUsage(arg, out);
                return 1;
            }
            if ("-trace".equals(arg)) continue;
            if ("-log".equals(arg) && SysProperties.OLD_COMMAND_LINE_OPTIONS) {
                ++i;
                continue;
            }
            if ("-ifExists".equals(arg)) {
                if (Server.readArgBoolean(args, i) == 0) continue;
                ++i;
                continue;
            }
            if ("-baseDir".equals(arg)) {
                ++i;
                continue;
            }
            this.showUsage(arg, out);
            return 1;
        }
        int exitCode = 0;
        if (startDefaultServers) {
            tcpStart = true;
            pgStart = true;
            webStart = true;
            browserStart = true;
        }
        if (tcpShutdown) {
            out.println("Shutting down TCP Server at " + tcpShutdownServer);
            Server.shutdownTcpServer(tcpShutdownServer, tcpPassword, tcpShutdownForce);
        }
        if (tcpStart) {
            this.tcp = Server.createTcpServer(args);
            try {
                this.tcp.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
                exitCode = 1;
            }
            out.println(this.tcp.getStatus());
        }
        if (pgStart) {
            this.pg = Server.createPgServer(args);
            try {
                this.pg.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
                exitCode = 1;
            }
            out.println(this.pg.getStatus());
        }
        if (webStart) {
            this.web = Server.createWebServer(args);
            this.web.setShutdownHandler(this);
            try {
                this.web.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
                exitCode = 1;
            }
            out.println(this.web.getStatus());
            if (browserStart) {
                StartBrowser.openURL(this.web.getURL());
            }
        }
        if (ftpStart) {
            this.ftp = Server.createFtpServer(args);
            try {
                this.ftp.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
                exitCode = 1;
            }
            out.println(this.ftp.getStatus());
        }
        return exitCode;
    }

    public static int readArgBoolean(String[] args, int i) {
        if (!SysProperties.OLD_COMMAND_LINE_OPTIONS) {
            return 0;
        }
        if (i + 1 < args.length) {
            String a;
            if ("true".equals(a = args[++i])) {
                return 1;
            }
            if ("false".equals(a)) {
                return -1;
            }
        }
        return 0;
    }

    public static void shutdownTcpServer(String url, String password, boolean force) throws SQLException {
        TcpServer.shutdown(url, password, force);
    }

    String getStatus() {
        StringBuffer buff = new StringBuffer();
        if (this.isRunning(false)) {
            buff.append(this.service.getType());
            buff.append(" server running on ");
            buff.append(this.service.getURL());
            buff.append(" (");
            if (this.service.getAllowOthers()) {
                buff.append("others can connect");
            } else {
                buff.append("only local connections");
            }
            buff.append(")");
        } else {
            buff.append("Port is in use, maybe another " + this.service.getType() + " server already running on ");
            buff.append(this.service.getURL());
        }
        return buff.toString();
    }

    public static Server createWebServer(String[] args) throws SQLException {
        WebServer service = new WebServer();
        Server server = new Server(service, args);
        service.setShutdownHandler(server);
        return server;
    }

    public static Server createFtpServer(String[] args) throws SQLException {
        return new Server(new FtpServer(), args);
    }

    public static Server createTcpServer(String[] args) throws SQLException {
        return new Server(new TcpServer(), args);
    }

    public static Server createPgServer(String[] args) throws SQLException {
        return new Server(new PgServer(), args);
    }

    public Server start() throws SQLException {
        this.service.start();
        Thread t = new Thread(this);
        t.setName(this.service.getName() + " (" + this.service.getURL() + ")");
        t.start();
        for (int i = 1; i < 64; i += i) {
            Server.wait(i);
            if (!this.isRunning(false)) continue;
            return this;
        }
        if (this.isRunning(true)) {
            return this;
        }
        throw Message.getSQLException(90067);
    }

    private static void wait(int i) {
        try {
            long sleep = (long)i * (long)i;
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void stopAll() {
        if (this.web != null && this.web.isRunning(false)) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning(false)) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning(false)) {
            this.pg.stop();
            this.pg = null;
        }
        if (this.ftp != null && this.ftp.isRunning(false)) {
            this.ftp.stop();
            this.ftp = null;
        }
    }

    public boolean isRunning(boolean traceError) {
        return this.service.isRunning(traceError);
    }

    public void stop() {
        this.service.stop();
    }

    public String getURL() {
        return this.service.getURL();
    }

    private Server(Service service, String[] args) throws SQLException {
        this.service = service;
        try {
            service.init(args);
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    public void run() {
        try {
            this.service.listen();
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    public void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        } else {
            this.stopAll();
        }
    }

    public Service getService() {
        return this.service;
    }
}

