/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.TraceInterceptor;
import org.seasar.framework.log.Logger;

public class ClassLoaderAwareTraceInterceptor
extends TraceInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(TraceInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!logger.isDebugEnabled()) {
            return invocation.proceed();
        }
        StringBuffer buf = new StringBuffer(256);
        this.appendClassLoader(buf, invocation.getThis());
        Class targetClass = this.getTargetClass(invocation);
        buf.append(targetClass.getName());
        buf.append("#");
        buf.append(invocation.getMethod().getName());
        buf.append("(");
        Object[] args = invocation.getArguments();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                this.appendObject(buf, arg);
                this.appendClassLoader(buf, arg);
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        Object ret = null;
        Throwable cause = null;
        logger.debug("BEGIN " + buf);
        try {
            ret = invocation.proceed();
            buf.append(" : ");
            this.appendObject(buf, ret);
            this.appendClassLoader(buf, ret);
        }
        catch (Throwable t) {
            buf.append(" Throwable:").append(t);
            cause = t;
        }
        logger.debug("END " + buf);
        if (cause != null) {
            throw cause;
        }
        return ret;
    }

    protected StringBuffer appendClassLoader(StringBuffer buf, Object obj) {
        ClassLoader classLoader;
        if (obj != null && (classLoader = obj.getClass().getClassLoader()) != null) {
            buf.append("<").append(classLoader.toString()).append(">");
        }
        return buf;
    }
}

