/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.FunctionCall;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.ParamType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractModuleCall;
import org.seasar.extension.jdbc.query.Param;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.PreparedStatementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFunctionCall<T, S extends FunctionCall<T, S>>
extends AbstractModuleCall<S>
implements FunctionCall<T, S> {
    protected Class<T> resultClass;
    protected boolean resultLob;
    protected boolean resultList;
    protected TemporalType resultTemporalType;

    public AbstractFunctionCall(JdbcManagerImplementor jdbcManager, Class<T> resultClass) {
        super(jdbcManager, true);
        this.resultClass = resultClass;
    }

    @Override
    public S lob() {
        this.resultLob = true;
        return (S)this;
    }

    @Override
    public S temporal(TemporalType temporalType) {
        this.resultTemporalType = temporalType;
        return (S)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getSingleResult() {
        this.resultList = false;
        this.prepare("getSingleResult");
        this.logSql();
        try {
            T t = this.getSingleResultInternal();
            return t;
        }
        finally {
            this.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getResultList() {
        this.resultList = true;
        this.prepare("getResultList");
        this.logSql();
        try {
            List<T> list = this.getResultListInternal();
            return list;
        }
        finally {
            this.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getSingleResultInternal() {
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            CallableStatement cs = this.getCallableStatement(jdbcContext);
            boolean resultSetGettable = PreparedStatementUtil.execute((PreparedStatement)cs);
            this.handleNonParamResultSets(cs, resultSetGettable);
            T result = this.handleSingleResult(cs);
            this.handleOutParams(cs);
            T t = result;
            return t;
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
            this.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> getResultListInternal() {
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            CallableStatement cs = this.getCallableStatement(jdbcContext);
            boolean resultSetGettable = PreparedStatementUtil.execute((PreparedStatement)cs);
            this.handleNonParamResultSets(cs, resultSetGettable);
            List<T> result = this.handleResultList(cs);
            this.handleOutParams(cs);
            List<T> list = result;
            return list;
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
    }

    protected void prepareReturnParameter() {
        ValueType valueType = this.getValueType(this.resultList ? List.class : this.resultClass, this.resultLob, this.resultTemporalType);
        Param p = this.addParam(null, this.resultClass, valueType);
        p.paramType = ParamType.OUT;
    }

    protected T handleSingleResult(CallableStatement cs) {
        try {
            Param param = this.getParam(0);
            return (T)param.valueType.getValue(cs, 1);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected List<T> handleResultList(CallableStatement cs) {
        try {
            Param param = this.getParam(0);
            ResultSet rs = (ResultSet)ResultSet.class.cast(param.valueType.getValue(cs, 1));
            return (List)this.handleResultList(this.resultClass, rs);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

