/*
 * Decompiled with CFR 0.152.
 */
package ow.dht;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class ByteArray
implements Externalizable {
    private static MessageDigest md = null;
    private static final String mdAlgoName = "SHA1";
    private byte[] barray;
    private volatile int hashCode;

    public ByteArray(byte[] bytes) {
        this.barray = bytes;
        this.init();
    }

    private void init() {
        int h = 0;
        for (int i = 0; i < this.barray.length; ++i) {
            h ^= this.barray[i] << i % 4 * 8;
        }
        this.hashCode = h;
    }

    public byte[] getBytes() {
        return this.barray;
    }

    public static ByteArray valueOf(String str, String encoding) throws UnsupportedEncodingException {
        return new ByteArray(str.getBytes(encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArray hashWithSHA1() {
        byte[] hashed;
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            hashed = md.digest(this.barray);
        }
        return new ByteArray(hashed);
    }

    public boolean equals(Object o) {
        ByteArray other;
        if (o == null) {
            return false;
        }
        try {
            other = (ByteArray)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (this.barray.length != other.barray.length) {
            return false;
        }
        for (int i = 0; i < this.barray.length; ++i) {
            if (this.barray[i] == other.barray[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("0x");
        for (int i = 0; i < this.barray.length; ++i) {
            int b = this.barray[i] & 0xFF;
            if (b < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(b));
        }
        return sb.toString();
    }

    public ByteArray() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int len = this.barray.length;
        if (len < 255) {
            out.writeByte(len);
        } else {
            out.writeByte(255);
            out.writeInt(len);
        }
        out.write(this.barray);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readByte() & 0xFF;
        if (len == 255) {
            len = in.readInt();
        }
        this.barray = new byte[len];
        in.readFully(this.barray);
        this.init();
    }

    static {
        try {
            md = MessageDigest.getInstance(mdAlgoName);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

