/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import ow.messaging.MessagingProvider;
import ow.messaging.upnp.Mapping;
import ow.messaging.upnp.UPnPManager;

public final class UPnPAddressPortMapper
implements Runnable {
    private String internalAddr;
    private int port;
    private Mapping.Protocol protocol;
    private String desc;
    private MessagingProvider provider;
    private long timeout;
    private static UPnPAddressPortMapper singletonInstance = null;
    private static Mapping addedMapping = null;
    private static InetAddress extAddress = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String internalAddress, int port, Mapping.Protocol protocol, String description, MessagingProvider provider, long timeout) {
        Class<UPnPAddressPortMapper> clazz = UPnPAddressPortMapper.class;
        synchronized (UPnPAddressPortMapper.class) {
            if (singletonInstance != null) {
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return;
            }
            singletonInstance = new UPnPAddressPortMapper(internalAddress, port, protocol, description, provider, timeout);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            Thread t = new Thread(singletonInstance);
            t.setName("UPnPAddressPortMapper");
            t.setDaemon(true);
            t.start();
            return;
        }
    }

    private UPnPAddressPortMapper(String internalAddress, int port, Mapping.Protocol protocol, String description, MessagingProvider provider, long timeout) {
        this.internalAddr = internalAddress;
        this.port = port;
        this.protocol = protocol;
        this.desc = description;
        this.provider = provider;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InetAddress extAddress;
        UPnPManager upnp = null;
        try {
            upnp = UPnPManager.getInstance();
        }
        catch (NoClassDefFoundError e) {
            System.out.println("UPnP library is not found and UPnP NAT Traversal is disabled.");
            System.out.println("If you want the function, add clink*.jar to your classpath.");
            System.out.println();
            return;
        }
        upnp.start();
        if (!upnp.waitForDeviceFound(this.timeout)) {
            upnp.stop();
            return;
        }
        Mapping map = new Mapping(this.port, this.internalAddr, this.port, this.protocol, this.desc);
        boolean succeed = upnp.addMapping(map);
        if (succeed) {
            addedMapping = map;
        }
        if ((extAddress = upnp.getExternalAddress()) != null) {
            if (this.provider != null) {
                try {
                    this.provider.setSelfAddress(extAddress.getHostAddress().toString());
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            UPnPAddressPortMapper.extAddress = extAddress;
        }
        upnp.stop();
        Class<UPnPAddressPortMapper> clazz = UPnPAddressPortMapper.class;
        synchronized (UPnPAddressPortMapper.class) {
            singletonInstance = null;
            // ** MonitorExit[var5_7] (shouldn't be in output)
            return;
        }
    }

    public static Mapping getAddedMapping() {
        return addedMapping;
    }

    public static InetAddress getExternalAddress() {
        return extAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTrying() {
        boolean trying = false;
        Class<UPnPAddressPortMapper> clazz = UPnPAddressPortMapper.class;
        synchronized (UPnPAddressPortMapper.class) {
            if (singletonInstance != null) {
                trying = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return trying;
        }
    }
}

