/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.IDAddressRoutingContextTriplet;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.RoutingContext;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.impl.AbstractRoutingDriver;
import ow.routing.impl.RoutingDriverMessageFactory;
import ow.stat.MessagingReporter;
import ow.util.concurrent.GlobalThreadPoolExecutors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecursiveRoutingDriver
extends AbstractRoutingDriver {
    private final Message recAckMessage;
    private static final int TAG_NULL = -1;
    private Map<ID, Message> routeResultMsgTable = new HashMap<ID, Message>();

    protected RecursiveRoutingDriver(RoutingServiceConfiguration conf, MessagingProvider provider, MessageReceiver receiver, RoutingAlgorithmProvider algoProvider, RoutingAlgorithmConfiguration algoConf, ID selfID) throws IOException {
        super(conf, provider, receiver, algoProvider, algoConf, selfID);
        this.recAckMessage = RoutingDriverMessageFactory.getRecAckMessage(this.getSelfIDAddressPair());
        this.prepareHandlers();
    }

    @Override
    public RoutingResult[] routeToRootNode(ID[] target, int numRootCandidates) {
        return this.route(this.adjustLastHop, Tag.REC_ROUTE_NONE, target, numRootCandidates, null, null, -1, null, null);
    }

    @Override
    public RoutingResult[] routeToClosestNode(ID[] target, int numRootCandidates) {
        return this.route(false, Tag.REC_ROUTE_NONE, target, numRootCandidates, null, null, -1, null, null);
    }

    @Override
    public RoutingResult[] invokeCallbacksOnRoute(ID[] target, int numRootCandidates, Serializable[][] returnedValueContainer, CallbackResultFilter filter, int tag, Serializable[][] args) {
        return this.route(this.adjustLastHop, Tag.REC_ROUTE_INVOKE, target, numRootCandidates, filter, returnedValueContainer, tag, args, null);
    }

    @Override
    public RoutingResult join(MessagingAddress initialContact) throws RoutingException {
        ID[] tgts = new ID[]{this.getSelfIDAddressPair().getID()};
        RoutingResult[] res = this.route(this.adjustLastHop, Tag.REC_ROUTE_JOIN, tgts, this.config.getNumOfRootCandidatesRequestedWhenJoining(), null, null, -1, null, initialContact);
        if (res == null || res[0] == null) {
            throw new RoutingException();
        }
        this.algorithm.join(res[0].getRootCandidates());
        return res[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RoutingResult[] route(boolean adjustLastHop, Tag msgType, ID[] target, int numRootCandidates, CallbackResultFilter filter, Serializable[][] resultingCallbackResult, int callbackTag, Serializable[][] callbackArgs, MessagingAddress joinInitialContact) {
        void var19_30;
        boolean filled;
        int i2;
        List[] closestNodes = new List[target.length];
        IDAddressPair[] blackList = null;
        if (numRootCandidates < 1) {
            numRootCandidates = 1;
        }
        if (msgType != Tag.REC_ROUTE_JOIN) {
            MessagingReporter msgReporter = this.receiver.getMessagingReporter();
            msgReporter.notifyStatCollectorOfEmphasizeNode(this.getSelfIDAddressPair(), this.getSelfIDAddressPair().getID());
            msgReporter.notifyStatCollectorOfMarkedID(this.getSelfIDAddressPair(), target, 0);
        }
        RoutingHop[] initialRoute = new RoutingHop[]{RoutingHop.newInstance(this.getSelfIDAddressPair())};
        RoutingContext[] initialRoutingContext = new RoutingContext[target.length];
        if (msgType == Tag.REC_ROUTE_JOIN) {
            initialRoutingContext = null;
            for (i2 = 0; i2 < target.length; ++i2) {
                closestNodes[i2] = new ArrayList();
                closestNodes[i2].add(IDAddressPair.getIDAddressPair(null, joinInitialContact));
            }
        } else {
            for (i2 = 0; i2 < target.length; ++i2) {
                IDAddressPair[] nodes;
                initialRoutingContext[i2] = this.algorithm.initialRoutingContext(target[i2]);
                closestNodes[i2] = new ArrayList();
                for (IDAddressPair iDAddressPair : nodes = this.algorithm.closestTo(target[i2], this.config.getNumOfClosestNodesRequested(), initialRoutingContext[i2])) {
                    closestNodes[i2].add(iDAddressPair);
                }
            }
        }
        Map<ID, Message> i2 = this.routeResultMsgTable;
        synchronized (i2) {
            Message nullMsg = new Message(null, -1, new Serializable[0]);
            for (int i3 = 0; i3 < target.length; ++i3) {
                this.routeResultMsgTable.put(target[i3], nullMsg);
            }
        }
        this.forwardOrReturnResult(adjustLastHop, false, msgType.getNumber(), null, closestNodes, initialRoutingContext, target, numRootCandidates, this.getSelfIDAddressPair(), this.config.getTTL(), filter, callbackTag, callbackArgs, initialRoute, blackList);
        RoutingResult[] ret = new RoutingResult[target.length];
        HashSet<Integer> failedIndexSet = new HashSet<Integer>();
        long sleepLimit = System.currentTimeMillis() + this.config.getRoutingTimeout();
        block10: do {
            Message resultMsg = null;
            Map<ID, Message> map = this.routeResultMsgTable;
            synchronized (map) {
                block11: while (true) {
                    for (int i4 = 0; i4 < target.length; ++i4) {
                        if (ret[i4] == null) {
                            resultMsg = this.routeResultMsgTable.get(target[i4]);
                        }
                        if (resultMsg != null && resultMsg.getTag() != -1) {
                            this.routeResultMsgTable.remove(target[i4]);
                            break block11;
                        }
                        resultMsg = null;
                    }
                    long sleepPeriod = sleepLimit - System.currentTimeMillis();
                    if (sleepPeriod <= 0L) {
                        for (ID id : target) {
                            this.routeResultMsgTable.remove(id);
                        }
                        break block10;
                    }
                    try {
                        this.routeResultMsgTable.wait(sleepPeriod);
                    }
                    catch (InterruptedException e) {
                        sleepLimit = System.currentTimeMillis();
                    }
                }
            }
            Serializable[] serializableArray = resultMsg.getContents();
            boolean succeed = (Boolean)serializableArray[1];
            ID[] tgt = (ID[])serializableArray[2];
            RoutingResult[] result = (RoutingResult[])serializableArray[3];
            Serializable[] callbackResult = (Serializable[])serializableArray[4];
            RoutingResult[] arr$ = result;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                RoutingHop h;
                IDAddressPair p;
                if (i$ >= len$) break;
                RoutingResult res = arr$[i$];
                RoutingHop[] route = res.getRoute();
                IDAddressPair selfIDAddress = this.getSelfIDAddressPair();
                RoutingHop[] arr$2 = route;
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2 && (p = (h = arr$2[i$2]).getIDAddressPair()) != null && !selfIDAddress.equals(p); ++i$2) {
                    this.algorithm.touch(p);
                }
                ++i$;
            }
            for (int i5 = 0; i5 < tgt.length; ++i5) {
                boolean match = false;
                for (int j = 0; j < target.length; ++j) {
                    if (!tgt[i5].equals(target[j])) continue;
                    match = true;
                    ret[j] = result[i5];
                    if (!succeed) {
                        failedIndexSet.add(j);
                    }
                    if (resultingCallbackResult == null || resultingCallbackResult[j] == null) continue;
                    resultingCallbackResult[j][0] = callbackResult[i5];
                }
                if (match) continue;
                logger.log(Level.WARNING, "Received REC_RESULT message is not for an expected target: " + tgt[i5]);
            }
            filled = true;
            for (int i6 = 0; i6 < target.length; ++i6) {
                if (ret[i6] != null) continue;
                filled = false;
            }
        } while (!filled);
        HashSet<ID> noResultTarget = new HashSet<ID>();
        boolean bl = false;
        while (var19_30 < target.length) {
            if (ret[var19_30] == null) {
                noResultTarget.add(target[var19_30]);
            }
            ++var19_30;
        }
        if (!noResultTarget.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ID id : noResultTarget) {
                stringBuilder.append(" ").append(id);
            }
            logger.log(Level.WARNING, "Could not receive a REC_RESULT message for the target" + stringBuilder.toString());
        }
        Iterator iterator = failedIndexSet.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            ret[index] = null;
        }
        return ret;
    }

    private void prepareHandlers() {
        MessageHandler handler = new MessageHandler(){

            public Message process(Message msg) {
                boolean terminate;
                RoutingHop[] route;
                IDAddressPair initiator;
                ID[] target;
                IDAddressPair[] blackList;
                Message ret = RecursiveRoutingDriver.this.recAckMessage;
                int numRootCandidates = 1;
                RoutingContext[] routingContext = null;
                int ttl = -1;
                boolean adjustLastHop = false;
                CallbackResultFilter filter = null;
                int callbackTag = -1;
                Serializable[][] callbackArgs = null;
                Serializable[] contents = msg.getContents();
                if (msg.getTag() == Tag.REC_ROUTE_NONE.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    target = (ID[])contents[1];
                    numRootCandidates = (Integer)contents[2];
                    routingContext = (RoutingContext[])contents[3];
                    initiator = (IDAddressPair)contents[4];
                    ttl = (Integer)contents[5];
                    adjustLastHop = (Boolean)contents[6];
                    route = (RoutingHop[])contents[7];
                    terminate = false;
                } else if (msg.getTag() == Tag.REC_ROUTE_INVOKE.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    target = (ID[])contents[1];
                    numRootCandidates = (Integer)contents[2];
                    routingContext = (RoutingContext[])contents[3];
                    initiator = (IDAddressPair)contents[4];
                    ttl = (Integer)contents[5];
                    adjustLastHop = (Boolean)contents[6];
                    filter = (CallbackResultFilter)contents[7];
                    callbackTag = (Integer)contents[8];
                    callbackArgs = (Serializable[][])contents[9];
                    route = (RoutingHop[])contents[10];
                    terminate = false;
                } else if (msg.getTag() == Tag.REC_ROUTE_JOIN.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    initiator = (IDAddressPair)contents[1];
                    target = new ID[]{initiator.getID()};
                    numRootCandidates = (Integer)contents[2];
                    routingContext = (RoutingContext[])contents[3];
                    ttl = (Integer)contents[4];
                    adjustLastHop = (Boolean)contents[5];
                    route = (RoutingHop[])contents[6];
                    terminate = false;
                } else if (msg.getTag() == Tag.REC_TERMINATE_NONE.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    target = (ID[])contents[1];
                    numRootCandidates = (Integer)contents[2];
                    initiator = (IDAddressPair)contents[3];
                    ttl = (Integer)contents[4];
                    route = (RoutingHop[])contents[5];
                    terminate = true;
                } else if (msg.getTag() == Tag.REC_TERMINATE_INVOKE.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    target = (ID[])contents[1];
                    numRootCandidates = (Integer)contents[2];
                    initiator = (IDAddressPair)contents[3];
                    ttl = (Integer)contents[4];
                    filter = (CallbackResultFilter)contents[5];
                    callbackTag = (Integer)contents[6];
                    callbackArgs = (Serializable[][])contents[7];
                    route = (RoutingHop[])contents[8];
                    terminate = true;
                } else if (msg.getTag() == Tag.REC_TERMINATE_JOIN.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    initiator = (IDAddressPair)contents[1];
                    target = new ID[]{initiator.getID()};
                    numRootCandidates = (Integer)contents[2];
                    ttl = (Integer)contents[3];
                    route = (RoutingHop[])contents[4];
                    terminate = true;
                } else {
                    AbstractRoutingDriver.logger.log(Level.WARNING, "Unexpected type of message: " + Tag.getNameByNumber(msg.getTag()));
                    return ret;
                }
                RoutingHop[] lastRoute = route;
                route = new RoutingHop[lastRoute.length + 1];
                System.arraycopy(lastRoute, 0, route, 0, lastRoute.length);
                route[route.length - 1] = RoutingHop.newInstance(RecursiveRoutingDriver.this.getSelfIDAddressPair());
                if (blackList != null) {
                    for (IDAddressPair p : blackList) {
                        AbstractRoutingDriver.logger.log(Level.INFO, "REC_*calls fail: " + p.getAddress() + " on " + RecursiveRoutingDriver.this.getSelfIDAddressPair().getAddress());
                        RecursiveRoutingDriver.this.fail(p);
                    }
                }
                if (routingContext == null) {
                    routingContext = new RoutingContext[target.length];
                }
                for (int i = 0; i < target.length; ++i) {
                    if (routingContext[i] != null) continue;
                    routingContext[i] = RecursiveRoutingDriver.this.algorithm.initialRoutingContext(target[i]);
                }
                List[] closestNodes = null;
                if (!terminate) {
                    closestNodes = new List[target.length];
                    for (int i = 0; i < target.length; ++i) {
                        IDAddressPair[] nodes;
                        closestNodes[i] = new ArrayList();
                        for (IDAddressPair p : nodes = RecursiveRoutingDriver.this.algorithm.closestTo(target[i], RecursiveRoutingDriver.this.config.getNumOfClosestNodesRequested(), routingContext[i])) {
                            closestNodes[i].add(p);
                        }
                    }
                }
                Forwarder f = new Forwarder(adjustLastHop, terminate, msg.getTag(), msg.getSource(), closestNodes, routingContext, target, numRootCandidates, initiator, ttl, filter, callbackTag, callbackArgs, route, blackList);
                if (RecursiveRoutingDriver.this.config.getUseThreadPool()) {
                    ExecutorService ex = GlobalThreadPoolExecutors.getThreadPool(false, false, Thread.currentThread().isDaemon());
                    ex.submit(f);
                } else {
                    Thread t = new Thread(f);
                    t.setName("Forwarder");
                    t.setDaemon(Thread.currentThread().isDaemon());
                    t.start();
                }
                return ret;
            }
        };
        this.addMessageHandler(Tag.REC_ROUTE_NONE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_ROUTE_INVOKE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_ROUTE_JOIN.getNumber(), handler);
        this.addMessageHandler(Tag.REC_TERMINATE_NONE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_TERMINATE_INVOKE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_TERMINATE_JOIN.getNumber(), handler);
        handler = new MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                IDAddressPair[] blackList = (IDAddressPair[])contents[0];
                ID[] target = (ID[])contents[2];
                Map map = RecursiveRoutingDriver.this.routeResultMsgTable;
                synchronized (map) {
                    if (target != null && target.length > 0) {
                        for (ID id : target) {
                            Message nullMsg = (Message)RecursiveRoutingDriver.this.routeResultMsgTable.get(id);
                            if (nullMsg == null || nullMsg.getTag() != -1) continue;
                            RecursiveRoutingDriver.this.routeResultMsgTable.put(id, msg);
                        }
                        RecursiveRoutingDriver.this.routeResultMsgTable.notifyAll();
                    }
                }
                if (blackList != null) {
                    for (IDAddressPair p : blackList) {
                        AbstractRoutingDriver.logger.log(Level.INFO, "REC_RESULT calls fail: " + p.getAddress() + " on " + RecursiveRoutingDriver.this.getSelfIDAddressPair().getAddress());
                        RecursiveRoutingDriver.this.fail(p);
                    }
                }
                return null;
            }
        };
        this.addMessageHandler(Tag.REC_RESULT.getNumber(), handler);
    }

    /*
     * Could not resolve type clashes
     */
    private boolean forwardOrReturnResult(boolean adjustLastHop, boolean terminate, int oldMsgTag, IDAddressPair lastHop, List<IDAddressPair>[] closestNodes, RoutingContext[] routingContext, final ID[] target, int numRootCandidates, IDAddressPair initiator, int ttl, CallbackResultFilter filter, int callbackTag, Serializable[][] callbackArgs, RoutingHop[] route, IDAddressPair[] blackList) {
        HashSet<IDAddressPair> blackListSet = new HashSet<IDAddressPair>();
        if (blackList != null) {
            for (IDAddressPair a : blackList) {
                blackListSet.add(a);
            }
        }
        boolean[] terminates = new boolean[target.length];
        for (int i = 0; i < target.length; ++i) {
            terminates[i] = terminate;
        }
        boolean succeed = true;
        boolean[] forwarded = new boolean[target.length];
        for (int i = 0; i < forwarded.length; ++i) {
            forwarded[i] = false;
        }
        IDAddressPair[][] rootCandidates = null;
        if (terminate) {
            int i;
            rootCandidates = new IDAddressPair[target.length][];
            for (i = 0; i < target.length; ++i) {
                rootCandidates[i] = this.algorithm.rootCandidates(target[i], numRootCandidates);
            }
            for (i = 0; i < target.length; ++i) {
                if (!this.getSelfIDAddressPair().equals(rootCandidates[i][0].getIDAddressPair())) {
                    adjustLastHop = true;
                    terminates[i] = false;
                    logger.log(Level.WARNING, "This node is not responsible node for " + target[i].toString(-1) + "... adjusted from " + this.getSelfIDAddressPair().getAddress() + " (" + this.getSelfIDAddressPair().getID().toString(-1) + ") to " + rootCandidates[i][0].getAddress() + " (" + rootCandidates[i][0].getID().toString(-1) + ").");
                    continue;
                }
                rootCandidates[i] = null;
            }
        }
        if (!terminate && ttl < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("TTL expired (target ");
            for (ID t : target) {
                sb.append(" ").append(t.toString().substring(0, 6));
            }
            sb.append("):");
            for (Serializable h : route) {
                if (h == null) break;
                sb.append(" ");
                sb.append(((RoutingHop)h).getIDAddressPair().getAddress().getHostname());
            }
            logger.log(Level.WARNING, sb.toString(), new Throwable());
            terminate = true;
            succeed = false;
        }
        IDAddressPair[] nextHops = new IDAddressPair[target.length];
        while (!terminate) {
            HashSet<IDAddressPair> contactSet = new HashSet<IDAddressPair>();
            boolean allContactsAreNull = true;
            boolean aContactIsNull = false;
            for (int i = 0; i < target.length; ++i) {
                block91: {
                    block93: {
                        RoutingContext cxt;
                        block92: {
                            block90: {
                                if (closestNodes[i] != null && closestNodes[i].size() > 0) break block90;
                                nextHops[i] = null;
                                break block91;
                            }
                            nextHops[i] = closestNodes[i].get(0);
                            cxt = null;
                            try {
                                cxt = ((IDAddressRoutingContextTriplet)nextHops[i]).getRoutingContext();
                            }
                            catch (ClassCastException e) {
                                // empty catch block
                            }
                            if (!nextHops[i].getAddress().equals(this.getSelfIDAddressPair().getAddress())) break block92;
                            if (cxt == null || routingContext != null && cxt.equals(routingContext[i])) {
                                nextHops[i] = null;
                            }
                            break block91;
                        }
                        if (!nextHops[i].getAddress().equals(initiator.getAddress())) break block93;
                        if (cxt != null) break block91;
                        nextHops[i] = null;
                        if (oldMsgTag != Tag.REC_ROUTE_JOIN.getNumber() && oldMsgTag != Tag.REC_TERMINATE_JOIN.getNumber()) break block91;
                        logger.log(Level.WARNING, "Next hop is the joining node " + initiator.getAddress() + ". RoutingAlgorithm#touch() has been called too early?");
                        break block91;
                    }
                    if (blackListSet.contains(nextHops[i].getAddress())) {
                        closestNodes[i].remove(0);
                        continue;
                    }
                }
                if (nextHops[i] != null) {
                    contactSet.add(nextHops[i].getIDAddressPair());
                    allContactsAreNull = false;
                    continue;
                }
                contactSet.add(null);
                aContactIsNull = true;
            }
            if (allContactsAreNull) break;
            if (contactSet.size() > 1 || aContactIsNull) {
                HashSet<Forwarder> forkedForwarder = new HashSet<Forwarder>();
                ArrayList<Integer> contactIndexList = new ArrayList<Integer>();
                for (IDAddressPair c : contactSet) {
                    int i;
                    contactIndexList.clear();
                    if (c == null) {
                        for (i = 0; i < target.length; ++i) {
                            if (nextHops[i] != null) continue;
                            contactIndexList.add(i);
                        }
                    } else {
                        for (i = 0; i < target.length; ++i) {
                            if (!c.equals(nextHops[i])) continue;
                            contactIndexList.add(i);
                        }
                    }
                    int nTgts = contactIndexList.size();
                    ID[] forkedTarget = new ID[nTgts];
                    List[] forkedClosestNodes = new List[nTgts];
                    for (int i2 = 0; i2 < nTgts; ++i2) {
                        int index = (Integer)contactIndexList.get(i2);
                        forkedTarget[i2] = target[index];
                        forkedClosestNodes[i2] = closestNodes[index];
                    }
                    Serializable[][] forkedCallbackArgs = null;
                    if (callbackArgs != null) {
                        forkedCallbackArgs = new Serializable[nTgts][];
                        for (int i3 = 0; i3 < nTgts; ++i3) {
                            int index = (Integer)contactIndexList.get(i3);
                            forkedCallbackArgs[i3] = callbackArgs[index];
                        }
                    }
                    Forwarder f = new Forwarder(adjustLastHop, terminate, oldMsgTag, lastHop, forkedClosestNodes, routingContext, forkedTarget, numRootCandidates, initiator, ttl, filter, callbackTag, forkedCallbackArgs, route, blackList);
                    forkedForwarder.add(f);
                }
                boolean ret = true;
                if (this.config.getUseThreadPool()) {
                    HashSet<Future<Boolean>> fSet = new HashSet<Future<Boolean>>();
                    for (Forwarder forwarder : forkedForwarder) {
                        ExecutorService ex = GlobalThreadPoolExecutors.getThreadPool(false, false, Thread.currentThread().isDaemon());
                        Future<Boolean> f = ex.submit(forwarder);
                        fSet.add(f);
                    }
                    for (Object f : fSet) {
                        try {
                            ret &= ((Boolean)f.get()).booleanValue();
                        }
                        catch (Exception e) {}
                    }
                } else {
                    HashSet<Thread> tSet = new HashSet<Thread>();
                    for (Forwarder r : forkedForwarder) {
                        Thread t = new Thread(r);
                        t.setName("Forwarder");
                        t.setDaemon(Thread.currentThread().isDaemon());
                        tSet.add(t);
                        t.start();
                    }
                    for (Thread t : tSet) {
                        try {
                            t.join();
                        }
                        catch (InterruptedException e) {}
                    }
                    for (Object f : forkedForwarder) {
                        ret &= ((Forwarder)f).getResult();
                    }
                }
                return ret;
            }
            RoutingContext[] nextContext = new RoutingContext[target.length];
            try {
                for (int i = 0; i < target.length; ++i) {
                    nextContext[i] = ((IDAddressRoutingContextTriplet)nextHops[i]).getRoutingContext();
                }
            }
            catch (ClassCastException e) {
                nextContext = null;
            }
            IDAddressPair nextHop = nextHops[0].getIDAddressPair();
            if (!((oldMsgTag == Tag.REC_ROUTE_JOIN.getNumber() || oldMsgTag == Tag.REC_TERMINATE_JOIN.getNumber()) && target[0].equals(nextHop.getID()) || nextHop.getID() != null && blackListSet.contains(nextHop.getIDAddressPair()))) {
                Message newMsg = oldMsgTag == Tag.REC_ROUTE_NONE.getNumber() ? RoutingDriverMessageFactory.getRecRouteNoneMessage(this.getSelfIDAddressPair(), target, numRootCandidates, nextContext, initiator, ttl - 1, adjustLastHop, route) : (oldMsgTag == Tag.REC_ROUTE_INVOKE.getNumber() ? RoutingDriverMessageFactory.getRecRouteInvokeMessage(this.getSelfIDAddressPair(), target, numRootCandidates, nextContext, initiator, ttl - 1, adjustLastHop, filter, callbackTag, callbackArgs, route) : RoutingDriverMessageFactory.getRecRouteJoinMessage(this.getSelfIDAddressPair(), initiator, numRootCandidates, nextContext, ttl - 1, adjustLastHop, route));
                RoutingDriverMessageFactory.setBlackList(newMsg, blackList);
                try {
                    int i;
                    Message ack = this.sender.sendAndReceive(nextHop.getAddress(), newMsg);
                    if (nextHop.getID() == null) {
                        nextHop.setID(ack.getSource().getID());
                    }
                    for (i = 0; i < target.length; ++i) {
                        if (nextHops[i].getID() != null) continue;
                        nextHops[i].setID(ack.getSource().getID());
                    }
                    if (this.algorithm != null) {
                        this.algorithm.touch(ack.getSource());
                    }
                    if (ack.getTag() == Tag.REC_ACK.getNumber()) {
                        for (i = 0; i < forwarded.length; ++i) {
                            forwarded[i] = true;
                        }
                        break;
                    }
                    logger.log(Level.SEVERE, "Received message is not REC_ACK.");
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to forward a request to " + nextHop.getAddress() + " on " + this.getSelfIDAddressPair().getAddress(), e);
                }
                if (nextHop.getID() != null) {
                    super.fail(nextHop);
                    if (blackList != null) {
                        IDAddressPair[] oldBlackList = blackList;
                        blackList = new IDAddressPair[oldBlackList.length + 1];
                        System.arraycopy(oldBlackList, 0, blackList, 0, oldBlackList.length);
                    } else {
                        blackList = new IDAddressPair[1];
                    }
                    blackList[blackList.length - 1] = nextHop;
                    blackListSet.add(nextHop);
                    logger.log(Level.INFO, nextHop.getAddress() + " is added to blacklist on " + this.getSelfIDAddressPair().getAddress());
                }
            }
            for (int i = 0; i < target.length; ++i) {
                if (closestNodes[i] == null) continue;
                if (closestNodes[i].size() <= 1) {
                    closestNodes[i] = null;
                    continue;
                }
                closestNodes[i].remove(0);
            }
        }
        if (!forwarded[0] && adjustLastHop) {
            List[] adjustedLastHops = new List[target.length];
            for (int i = 0; i < target.length; ++i) {
                if (terminates[i]) {
                    adjustedLastHops[i] = null;
                    continue;
                }
                adjustedLastHops[i] = new LinkedList();
                IDAddressPair[] l = rootCandidates != null && rootCandidates[i] != null ? rootCandidates[i] : this.algorithm.adjustRoot(target[i]);
                for (IDAddressPair p : l) {
                    if (p == null) continue;
                    adjustedLastHops[i].add(p);
                }
            }
            HashSet<IDAddressPair> nextHopSet = new HashSet<IDAddressPair>();
            ArrayList<Integer> nextHopIndexList = new ArrayList<Integer>();
            block43: while (true) {
                nextHops = new IDAddressPair[target.length];
                nextHopSet.clear();
                for (int i = 0; i < target.length; ++i) {
                    if (adjustedLastHops[i] == null || adjustedLastHops[i].isEmpty() || forwarded[i]) continue;
                    do {
                        try {
                            nextHops[i] = (IDAddressPair)adjustedLastHops[i].remove(0);
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                    } while (nextHops[i] != null && (blackListSet.contains(nextHops[i].getIDAddressPair()) || oldMsgTag == Tag.ITE_ROUTE_JOIN.getNumber() && this.getSelfIDAddressPair().equals(nextHops[i])));
                    if (nextHops[i] == null) continue;
                    nextHopSet.add(nextHops[i].getIDAddressPair());
                }
                if (nextHopSet.isEmpty()) break;
                Iterator i$ = nextHopSet.iterator();
                block46: while (true) {
                    if (!i$.hasNext()) continue block43;
                    IDAddressPair nextHop = (IDAddressPair)i$.next();
                    nextHopIndexList.clear();
                    for (int i = 0; i < target.length; ++i) {
                        if (!nextHop.equals(nextHops[i])) continue;
                        nextHopIndexList.add(i);
                    }
                    ID[] forkedTarget = new ID[nextHopIndexList.size()];
                    for (int i = 0; i < nextHopIndexList.size(); ++i) {
                        forkedTarget[i] = target[(Integer)nextHopIndexList.get(i)];
                    }
                    Message newMsg = oldMsgTag == Tag.REC_ROUTE_NONE.getNumber() || oldMsgTag == Tag.REC_TERMINATE_NONE.getNumber() ? RoutingDriverMessageFactory.getRecTerminateNoneMessage(this.getSelfIDAddressPair(), forkedTarget, numRootCandidates, initiator, ttl - 1, route) : (oldMsgTag == Tag.REC_ROUTE_INVOKE.getNumber() || oldMsgTag == Tag.REC_TERMINATE_INVOKE.getNumber() ? RoutingDriverMessageFactory.getRecTerminateInvokeMessage(this.getSelfIDAddressPair(), forkedTarget, numRootCandidates, initiator, ttl - 1, filter, callbackTag, callbackArgs, route) : RoutingDriverMessageFactory.getRecTerminateJoinMessage(this.getSelfIDAddressPair(), initiator, numRootCandidates, ttl - 1, route));
                    RoutingDriverMessageFactory.setBlackList(newMsg, blackList);
                    try {
                        int i;
                        Message ack = this.sender.sendAndReceive(nextHop.getAddress(), newMsg);
                        this.algorithm.touch(ack.getSource());
                        Iterator i$2 = nextHopIndexList.iterator();
                        while (i$2.hasNext()) {
                            i = (Integer)i$2.next();
                            adjustedLastHops[i] = null;
                        }
                        if (ack.getTag() == Tag.REC_ACK.getNumber()) {
                            i$2 = nextHopIndexList.iterator();
                            while (true) {
                                if (!i$2.hasNext()) continue block46;
                                i = (Integer)i$2.next();
                                forwarded[i] = true;
                            }
                        }
                        logger.log(Level.SEVERE, "Received message is not REC_ACK.");
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to forward a request to " + nextHop.getAddress() + " on " + this.getSelfIDAddressPair().getAddress(), e);
                    }
                    super.fail(nextHop);
                    if (blackList != null) {
                        IDAddressPair[] oldBlackList = blackList;
                        blackList = new IDAddressPair[oldBlackList.length + 1];
                        System.arraycopy(oldBlackList, 0, blackList, 0, oldBlackList.length);
                    } else {
                        blackList = new IDAddressPair[1];
                    }
                    blackList[blackList.length - 1] = nextHop;
                    succeed = false;
                }
                break;
            }
        }
        if (lastHop != null) {
            this.algorithm.touch(lastHop);
        }
        if (!this.getSelfIDAddressPair().equals(initiator)) {
            this.algorithm.touch(initiator);
        }
        Serializable[] callbackResult = new Serializable[target.length];
        if (oldMsgTag == Tag.REC_ROUTE_INVOKE.getNumber() || oldMsgTag == Tag.REC_TERMINATE_INVOKE.getNumber()) {
            for (int i = 0; i < target.length; ++i) {
                callbackResult[i] = this.invokeCallbacks(target[i], callbackTag, callbackArgs[i], filter, lastHop, !forwarded[i]);
                if (callbackResult[i] == null) continue;
                logger.log(Level.INFO, "A callback returned non-null object: " + callbackResult[i]);
            }
        } else if (oldMsgTag == Tag.REC_ROUTE_JOIN.getNumber() || oldMsgTag == Tag.REC_TERMINATE_JOIN.getNumber()) {
            final IDAddressPair copiedJoiningNode = initiator;
            final IDAddressPair copiedLastHop = lastHop;
            final boolean[] copiedForwarded = new boolean[forwarded.length];
            System.arraycopy(forwarded, 0, copiedForwarded, 0, copiedForwarded.length);
            Runnable r = new Runnable(){

                public void run() {
                    for (int i = 0; i < target.length; ++i) {
                        RecursiveRoutingDriver.this.algorithm.join(copiedJoiningNode, copiedLastHop, !copiedForwarded[i]);
                    }
                }
            };
            try {
                if (this.config.getUseThreadPool()) {
                    ExecutorService ex = GlobalThreadPoolExecutors.getThreadPool(false, false, Thread.currentThread().isDaemon());
                    ex.submit(r);
                }
                Thread t = new Thread(r);
                t.setName("Message type specific processes");
                t.setDaemon(Thread.currentThread().isDaemon());
                t.start();
            }
            catch (OutOfMemoryError e) {
                logger.log(Level.SEVERE, "# of threads: " + Thread.activeCount(), e);
                throw e;
            }
        }
        ArrayList<Integer> notForwardedIndexList = new ArrayList<Integer>();
        for (int i = 0; i < target.length; ++i) {
            if (forwarded[i]) continue;
            notForwardedIndexList.add(i);
        }
        if (!notForwardedIndexList.isEmpty()) {
            ID[] partOfTarget = new ID[notForwardedIndexList.size()];
            RoutingResult[] partOfResult = new RoutingResult[notForwardedIndexList.size()];
            Serializable[] partOfCallbackResult = new Serializable[notForwardedIndexList.size()];
            for (int i = 0; i < notForwardedIndexList.size(); ++i) {
                partOfTarget[i] = target[(Integer)notForwardedIndexList.get(i)];
                IDAddressPair[] rootCands = this.algorithm.rootCandidates(partOfTarget[i], numRootCandidates);
                if ((oldMsgTag == Tag.REC_ROUTE_JOIN.getNumber() || oldMsgTag == Tag.REC_TERMINATE_JOIN.getNumber()) && initiator.equals(rootCands[0])) {
                    IDAddressPair[] orig = rootCands;
                    rootCands = new IDAddressPair[rootCands.length - 1];
                    System.arraycopy(orig, 1, rootCands, 0, rootCands.length);
                }
                partOfResult[i] = new RoutingResult(route, rootCands);
                partOfCallbackResult[i] = callbackResult[(Integer)notForwardedIndexList.get(i)];
            }
            Message repMsg = RoutingDriverMessageFactory.getRecResultMessage(this.getSelfIDAddressPair(), succeed, partOfTarget, partOfResult, partOfCallbackResult);
            RoutingDriverMessageFactory.setBlackList(repMsg, blackList);
            try {
                this.sender.send(initiator.getAddress(), repMsg);
                Iterator i$ = notForwardedIndexList.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    forwarded[i] = true;
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to report to the initiator: " + initiator.getAddress() + " on " + this.getSelfIDAddressPair().getAddress());
                super.fail(initiator);
            }
        }
        boolean ret = true;
        for (boolean b : forwarded) {
            ret &= b;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Forwarder
    implements Callable<Boolean>,
    Runnable {
        private final boolean adjustLastHop;
        private final boolean terminate;
        private final int msgTag;
        private final IDAddressPair lastHop;
        private final List<IDAddressPair>[] closestNodes;
        private final RoutingContext[] routingContext;
        private final ID[] target;
        private final int numRootCandidates;
        private final IDAddressPair initiator;
        private int ttl;
        private final CallbackResultFilter filter;
        private final int callbackTag;
        private final Serializable[][] callbackArgs;
        private final RoutingHop[] route;
        private final IDAddressPair[] blackList;
        private boolean result;

        Forwarder(boolean adjustLastHop, boolean terminate, int msgTag, IDAddressPair lastHop, List<IDAddressPair>[] closestNodes, RoutingContext[] routingContext, ID[] target, int numRootCandidates, IDAddressPair initiator, int ttl, CallbackResultFilter filter, int callbackTag, Serializable[][] callbackArgs, RoutingHop[] route, IDAddressPair[] blackList) {
            this.adjustLastHop = adjustLastHop;
            this.terminate = terminate;
            this.msgTag = msgTag;
            this.lastHop = lastHop;
            this.closestNodes = closestNodes;
            this.routingContext = routingContext;
            this.target = target;
            this.numRootCandidates = numRootCandidates;
            this.initiator = initiator;
            this.ttl = ttl;
            this.filter = filter;
            this.callbackTag = callbackTag;
            this.callbackArgs = callbackArgs;
            this.route = route;
            this.blackList = blackList;
        }

        @Override
        public void run() {
            try {
                this.call();
            }
            catch (Exception e) {
                AbstractRoutingDriver.logger.log(Level.SEVERE, "A Querier threw an exception.", e);
            }
        }

        @Override
        public Boolean call() throws Exception {
            this.result = RecursiveRoutingDriver.this.forwardOrReturnResult(this.adjustLastHop, this.terminate, this.msgTag, this.lastHop, this.closestNodes, this.routingContext, this.target, this.numRootCandidates, this.initiator, this.ttl, this.filter, this.callbackTag, this.callbackArgs, this.route, this.blackList);
            return this.result;
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

