/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.linearwalker;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedFromSrcIDAddrPairComparator;
import ow.routing.linearwalker.LinearWalker;

public final class SuccessorList {
    private final IDAddressPair selfIDAddress;
    private final int maxLength;
    private final SortedSet<IDAddressPair> list;
    private final LinearWalker algo;

    public SuccessorList(LinearWalker algo, IDAddressPair selfIDAddress, int maxLength) {
        this.algo = algo;
        this.selfIDAddress = selfIDAddress;
        this.maxLength = maxLength;
        this.list = new TreeSet<IDAddressPair>(new AlgoBasedFromSrcIDAddrPairComparator(algo, selfIDAddress.getID()));
        this.list.add(selfIDAddress);
    }

    synchronized void clear() {
        this.list.clear();
        this.list.add(this.selfIDAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IDAddressPair elem) {
        if (elem == null) {
            return;
        }
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            boolean added = this.list.add(elem);
            if (added && this.maxLength > 0) {
                while (this.list.size() > this.maxLength) {
                    IDAddressPair lastElem = this.list.last();
                    this.list.remove(lastElem);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(IDAddressPair[] elems) {
        if (elems == null) {
            return;
        }
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            boolean added = false;
            for (IDAddressPair elem : elems) {
                added |= this.list.add(elem);
            }
            if (added && this.maxLength > 0) {
                while (this.list.size() > this.maxLength) {
                    IDAddressPair lastElem = this.list.last();
                    this.list.remove(lastElem);
                }
            }
        }
    }

    public boolean contains(IDAddressPair elem) {
        if (elem == null) {
            return false;
        }
        return this.list.contains(elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IDAddressPair elem) {
        boolean ret;
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            ret = this.list.remove(elem);
            if (this.list.isEmpty()) {
                this.list.add(this.selfIDAddress);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDAddressPair first() {
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            try {
                return this.list.first();
            }
            catch (NoSuchElementException e) {
                this.list.add(this.selfIDAddress);
                return this.selfIDAddress;
            }
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDAddressPair[] toArray() {
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            return this.list.toArray(new IDAddressPair[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IDAddressPair[] rootCandidates(ID target, int maxLen, IDAddressPair predecessor) {
        BigInteger targetMinusOneInt = target.toBigInteger().subtract(BigInteger.ONE);
        if (targetMinusOneInt.compareTo(BigInteger.ZERO) < 0) {
            targetMinusOneInt = targetMinusOneInt.add(this.algo.sizeOfIdSpace);
        }
        ID targetMinusOne = ID.getID(targetMinusOneInt, target.getSize());
        TreeSet<IDAddressPair> retSet = new TreeSet<IDAddressPair>(new AlgoBasedFromSrcIDAddrPairComparator(this.algo, targetMinusOne));
        retSet.add(this.selfIDAddress);
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            retSet.addAll(this.list);
        }
        if (predecessor != null) {
            retSet.add(predecessor);
        }
        int len = Math.min(maxLen, retSet.size());
        IDAddressPair[] ret = new IDAddressPair[len];
        int i = 0;
        for (IDAddressPair p : retSet) {
            if (i >= len) break;
            ret[i++] = p;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDAddressPair[] closestNodes(ID target, boolean includeSelf) {
        IDAddressPair toElement = IDAddressPair.getIDAddressPair(target, null);
        ArrayList<IDAddressPair> result = new ArrayList<IDAddressPair>();
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            SortedSet<IDAddressPair> smallerHalf = this.list.headSet(toElement);
            SortedSet<IDAddressPair> largerHalf = this.list.tailSet(toElement);
            if (!includeSelf) {
                smallerHalf.remove(this.selfIDAddress);
                largerHalf.remove(this.selfIDAddress);
            }
            result.addAll(largerHalf);
            if (includeSelf && !this.list.contains(this.selfIDAddress)) {
                result.add(this.selfIDAddress);
            }
            result.addAll(smallerHalf);
        }
        int len = result.size();
        IDAddressPair[] ret = new IDAddressPair[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (IDAddressPair)result.get(len - 1 - i);
        }
        return ret;
    }
}

