/*
 * Decompiled with CFR 0.152.
 */
package ow.stat;

import java.io.IOException;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingConfiguration;
import ow.messaging.MessagingFactory;
import ow.messaging.MessagingProvider;
import ow.messaging.Signature;

public final class StatConfiguration {
    private static final String DEFAULT_MESSAGING_TRANSPORT = "UDP";
    private static final int DEFAULT_SELF_PORT = 3997;
    private static final int DEFAULT_SELF_PORT_RANGE = 100;
    private static final int DEFAULT_CONTACT_PORT = 3997;
    public static final boolean DEFAULT_DO_UPNP_NAT_TRAVERSAL = true;
    private static final int DEFAULT_PING_FREQUENCY = 25;
    private static final int DEFAULT_NUM_OF_FAILURES_BEFORE_FORGET_COLLECTOR = 2;
    private static final int DEFAULT_NUM_OF_NODES_NODE_COLLECTOR_REQUESTS = 40;
    private static final int DEFAULT_NODE_COLLECTOR_CONCURRENCY = 20;
    private static final long DEFAULT_PERIODIC_COLLECTION_INTERVAL = 10000L;
    private String messagingTransport = "UDP";
    private int selfPort = 3997;
    private int selfPortRange = 100;
    private int contactPort = 3997;
    private boolean doUPnPNATTraversal = true;
    private int pingFrequency = 25;
    private int numOfFailuresBeforeForgetCollector = 2;
    private int numOfNodesNodeCollectorRequests = 40;
    private int nodeCollectorConcurrency = 20;
    private long periodicCollectionInterval = 10000L;
    private String selfHost = null;

    protected StatConfiguration() {
    }

    public String getMessagingTransport() {
        return this.messagingTransport;
    }

    public String setMessagingTransport(String transport) {
        String old = this.messagingTransport;
        this.messagingTransport = transport;
        return old;
    }

    public int getSelfPort() {
        return this.selfPort;
    }

    public int setSelfPort(int port) {
        int old = this.selfPort;
        this.selfPort = port;
        return old;
    }

    public int getSelfPortRange() {
        return this.selfPortRange;
    }

    public int setSelfPortRange(int range) {
        int old = this.selfPortRange;
        this.selfPortRange = range;
        return old;
    }

    public int getContactPort() {
        return this.contactPort;
    }

    public int setContactPort(int port) {
        int old = this.contactPort;
        this.contactPort = port;
        return old;
    }

    public boolean getDoUPnPNATTraversal() {
        return this.doUPnPNATTraversal;
    }

    public boolean setDoUPnPNATTraversal(boolean flag) {
        boolean old = this.doUPnPNATTraversal;
        this.doUPnPNATTraversal = flag;
        return old;
    }

    public int getPingFrequency() {
        return this.pingFrequency;
    }

    public int setPingFrequency(int freq) {
        int old = this.pingFrequency;
        this.pingFrequency = freq;
        return old;
    }

    public int getNumOfFailuresBeforeForgetCollector() {
        return this.numOfFailuresBeforeForgetCollector;
    }

    public int setNumOfFailuresBeforeForgetCollector(int num) {
        int old = this.numOfFailuresBeforeForgetCollector;
        this.numOfFailuresBeforeForgetCollector = num;
        return old;
    }

    public int getNumOfNodesNodeCollectorRequests() {
        return this.numOfNodesNodeCollectorRequests;
    }

    public int setNumOfNodesNodeCollectorRequests(int num) {
        int old = this.numOfNodesNodeCollectorRequests;
        this.numOfNodesNodeCollectorRequests = num;
        return old;
    }

    public int getNodeCollectorConcurrency() {
        return this.nodeCollectorConcurrency;
    }

    public int setNodeCollectorConcurrency(int concurrency) {
        int old = this.nodeCollectorConcurrency;
        this.nodeCollectorConcurrency = concurrency;
        return old;
    }

    public long getPeriodicCollectionInterval() {
        return this.periodicCollectionInterval;
    }

    public long setPeriodicCollectionInterval(long interval) {
        long old = this.periodicCollectionInterval;
        this.periodicCollectionInterval = interval;
        return old;
    }

    public String getSelfAddress() {
        return this.selfHost;
    }

    public String setSelfAddress(String host) {
        String old = this.selfHost;
        this.selfHost = host;
        return old;
    }

    public MessagingProvider deriveMessagingProvider() throws Exception {
        MessagingProvider provider = MessagingFactory.getProvider(this.getMessagingTransport(), Signature.getAllAcceptingSignature());
        if (this.getSelfAddress() != null) {
            provider.setSelfAddress(this.getSelfAddress());
        }
        return provider;
    }

    public MessageReceiver deriveMessageReceiver(MessagingProvider provider) throws IOException {
        MessagingConfiguration msgConfig = provider.getDefaultConfiguration();
        msgConfig.setDoUPnPNATTraversal(this.getDoUPnPNATTraversal());
        MessageReceiver receiver = provider.getReceiver(msgConfig, this.getSelfPort(), this.getSelfPortRange());
        this.setSelfPort(receiver.getPort());
        return receiver;
    }
}

