/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import ow.ipmulticast.IPMulticast;
import ow.ipmulticast.igmpd.IGMPDaemon;
import ow.ipmulticast.igmpd.IGMPDaemonConfiguration;
import ow.mcast.Mcast;
import ow.tool.mcastshell.commands.HaltCommand;
import ow.tool.mcastshell.commands.HelpCommand;
import ow.tool.mcastshell.commands.InitCommand;
import ow.tool.mcastshell.commands.NeighborsCommand;
import ow.tool.mcastshell.commands.QuitCommand;
import ow.tool.mcastshell.commands.StatusCommand;
import ow.tool.mrouted.ApplicationLevelMulticastRouter;
import ow.tool.mrouted.ApplicationLevelMulticastRouterConfiguration;
import ow.tool.mrouted.commands.GroupsCommand;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.MessagePrinter;
import ow.tool.util.shellframework.ShellServer;
import ow.tool.util.toolframework.AbstractMcastBasedTool;

public class Main
extends AbstractMcastBasedTool {
    private static final String COMMAND = "owmrouted";
    private final int DEFAULT_SHELL_PORT = -1;
    private static final Class[] COMMANDS = new Class[]{InitCommand.class, GroupsCommand.class, NeighborsCommand.class, StatusCommand.class, HelpCommand.class, QuitCommand.class, HaltCommand.class};
    private static final List<Command<ApplicationLevelMulticastRouter>> commandList = ShellServer.createCommandList(COMMANDS);
    private static final Map<String, Command<ApplicationLevelMulticastRouter>> commandTable = ShellServer.createCommandTable(commandList);

    protected void usage(String command) {
        super.usage(command, "[-p <shell port>]");
    }

    public static void main(String[] args) {
        new Main().start(args);
    }

    protected void start(String[] args) {
        int shellPort = -1;
        Options opts = this.getInitialOptions();
        opts.addOption("p", "port", true, "port number");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            System.out.println("There is an invalid option.");
            e.printStackTrace();
            System.exit(1);
        }
        parser = null;
        opts = null;
        String optVal = cmd.getOptionValue('p');
        if (optVal != null) {
            shellPort = Integer.parseInt(optVal);
        }
        IGMPDaemon igmpd = null;
        IPMulticast mcast = null;
        Mcast mcService = null;
        try {
            igmpd = new IGMPDaemon(new IGMPDaemonConfiguration());
            mcast = IPMulticast.getInstance();
            mcService = super.initialize((short)3, (short)1, COMMAND, cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        cmd = null;
        ApplicationLevelMulticastRouterConfiguration config = new ApplicationLevelMulticastRouterConfiguration();
        ApplicationLevelMulticastRouter almRouter = null;
        try {
            almRouter = new ApplicationLevelMulticastRouter(config, igmpd, mcast, mcService);
            almRouter.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (shellPort >= 0 && shellPort < 65536) {
            ShellServer<ApplicationLevelMulticastRouter> shellServ = new ShellServer<ApplicationLevelMulticastRouter>(commandTable, commandList, new ShowPromptPrinter(), new NoCommandPrinter(), null, almRouter, shellPort);
        }
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException e) {
            System.err.println("sleep interrupted.");
        }
    }

    private static class NoCommandPrinter
    implements MessagePrinter {
        private NoCommandPrinter() {
        }

        public void execute(PrintStream out, String hint) {
            out.print("No such command");
            if (hint != null) {
                out.print(": " + hint);
            } else {
                out.print(".");
            }
            out.print("\r\n");
            out.flush();
        }
    }

    private static class ShowPromptPrinter
    implements MessagePrinter {
        private ShowPromptPrinter() {
        }

        public void execute(PrintStream out, String hint) {
            out.print("Ready.\r\n");
            out.flush();
        }
    }
}

