/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.toolframework;

import java.io.Serializable;
import java.net.UnknownHostException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.DHTFactory;
import ow.id.ID;
import ow.messaging.util.MessagingUtility;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDHTBasedTool<V extends Serializable> {
    private final int MAX_ID_SIZE = 20;

    protected abstract void usage(String var1);

    protected void usage(String command, String optionDescriptions) {
        System.out.print("Usage: " + command);
        if (optionDescriptions != null) {
            System.out.print(" ");
            System.out.print(optionDescriptions);
        }
        System.out.println(" [-d <working dir>] [-i <self ID>] [-m <stat collector addr>[:<port>]] [-t UDP|TCP] [-a <algorithm name>] [-r <routing style>] [-s [<self address>[:<port>]]|<port>] [--no-upnp] [<host>[:<port>]] [<port>]");
    }

    protected Options getInitialOptions() {
        Options opts = new Options();
        opts.addOption("h", "help", false, "print help");
        opts.addOption("d", "directory", true, "working directory");
        opts.addOption("i", "id", true, "self ID");
        opts.addOption("m", "statcollector", true, "address of stat collector");
        opts.addOption("t", "transport", true, "transport, UDP or TCP");
        opts.addOption("a", "algorithm", true, "routing algorithm");
        opts.addOption("r", "routingstyle", true, "routing style, Iterative or Recursive");
        opts.addOption("s", "selfaddress", true, "self IP address");
        opts.addOption("N", "no-upnp", false, "disable UPnP address port mapping");
        return opts;
    }

    protected DHT<V> initialize(short applicationID, short applicationVersion, DHTConfiguration config, String command, CommandLine cmd) throws Exception {
        String optVal;
        String transport = null;
        String algorithm = null;
        String routingStyle = null;
        String workingDir = null;
        ID selfID = null;
        String statCollectorAddressAndPort = null;
        String selfAddressAndPort = null;
        boolean noUPnP = false;
        boolean join = false;
        if (cmd.hasOption('h')) {
            this.usage(command);
            System.exit(1);
        }
        if ((optVal = cmd.getOptionValue('d')) != null) {
            workingDir = optVal;
        }
        if ((optVal = cmd.getOptionValue('i')) != null) {
            selfID = ID.getID(optVal, 20);
        }
        if ((optVal = cmd.getOptionValue('m')) != null) {
            statCollectorAddressAndPort = optVal;
        }
        if ((optVal = cmd.getOptionValue('t')) != null) {
            transport = optVal;
        }
        if ((optVal = cmd.getOptionValue('a')) != null) {
            algorithm = optVal;
        }
        if ((optVal = cmd.getOptionValue('r')) != null) {
            routingStyle = optVal;
        }
        if ((optVal = cmd.getOptionValue('s')) != null) {
            selfAddressAndPort = optVal;
        }
        if (cmd.hasOption('N')) {
            noUPnP = true;
        }
        String[] args = cmd.getArgs();
        String contactHostAndPort = null;
        int contactPort = -1;
        String contactString = null;
        if (args.length >= 1) {
            contactHostAndPort = args[0];
            join = true;
            if (args.length >= 2) {
                contactPort = Integer.parseInt(args[1]);
            }
        }
        if (transport != null) {
            config.setMessagingTransport(transport);
        }
        if (algorithm != null) {
            config.setRoutingAlgorithm(algorithm);
        }
        if (routingStyle != null) {
            config.setRoutingStyle(routingStyle);
        }
        if (workingDir != null) {
            config.setWorkingDirectory(workingDir);
        }
        if (selfAddressAndPort != null) {
            MessagingUtility.HostAndPort hostAndPort = MessagingUtility.parseHostnameAndPort(selfAddressAndPort, config.getSelfPort());
            config.setSelfAddress(hostAndPort.getHostName());
            config.setSelfPort(hostAndPort.getPort());
        }
        if (noUPnP) {
            config.setDoUPnPNATTraversal(false);
        }
        DHT dht = DHTFactory.getDHT(applicationID, applicationVersion, config, selfID);
        StringBuilder sb = new StringBuilder();
        sb.append("DHT configuration:\n");
        sb.append("  hostname:port:     ").append(dht.getSelfIDAddressPair().getAddress()).append('\n');
        sb.append("  transport type:    ").append(config.getMessagingTransport()).append('\n');
        sb.append("  routing algorithm: ").append(config.getRoutingAlgorithm()).append('\n');
        sb.append("  routing style:     ").append(config.getRoutingStyle()).append('\n');
        sb.append("  directory type:    ").append(config.getDirectoryType()).append('\n');
        sb.append("  working directory: ").append(config.getWorkingDirectory()).append('\n');
        System.out.print(sb);
        try {
            if (statCollectorAddressAndPort != null) {
                StatConfiguration statConfig = StatFactory.getDefaultConfiguration();
                MessagingUtility.HostAndPort hostAndPort = MessagingUtility.parseHostnameAndPort(statCollectorAddressAndPort, statConfig.getSelfPort());
                dht.setStatCollectorAddress(hostAndPort.getHostName(), hostAndPort.getPort());
            }
            if (join) {
                if (contactPort >= 0) {
                    dht.joinOverlay(contactHostAndPort, contactPort);
                    contactString = contactHostAndPort + " : " + contactPort;
                } else {
                    try {
                        dht.joinOverlay(contactHostAndPort);
                        contactString = contactHostAndPort;
                    }
                    catch (IllegalArgumentException e) {
                        contactPort = config.getContactPort();
                        dht.joinOverlay(contactHostAndPort, contactPort);
                        contactString = contactHostAndPort + ":" + contactPort;
                    }
                }
            }
        }
        catch (UnknownHostException e) {
            System.err.println("A hostname could not be resolved: " + contactHostAndPort);
            e.printStackTrace();
            System.exit(1);
        }
        if (join) {
            System.out.println("  initial contact:   " + contactString);
        }
        System.out.println("A DHT started.");
        System.out.flush();
        return dht;
    }
}

