/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.visualizer;

import ow.id.ID;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.util.MessagingUtility;
import ow.stat.MessagingCallbackExtended;
import ow.stat.MessagingCollector;
import ow.stat.NodeCollector;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;
import ow.tool.util.vizframework.Visualizer;

public final class OverlayVisualizer {
    private Visualizer viz;
    private MessagingCollector collector;

    public OverlayVisualizer(String transport, int idSizeInBit, String selfAddressAndPort, boolean noUPnP, String contactHostAndPort, int contactPort) throws Exception {
        this.viz = new Visualizer(idSizeInBit);
        StatConfiguration config = StatFactory.getDefaultConfiguration();
        if (transport != null) {
            config.setMessagingTransport(transport);
        }
        if (selfAddressAndPort != null) {
            MessagingUtility.HostAndPort hostAndPort = MessagingUtility.parseHostnameAndPort(selfAddressAndPort, config.getSelfPort());
            config.setSelfAddress(hostAndPort.getHostName());
            config.setSelfPort(hostAndPort.getPort());
        }
        if (noUPnP) {
            config.setDoUPnPNATTraversal(false);
        }
        this.collector = StatFactory.getMessagingCollector(config);
        this.collector.start(new VizCallback());
        if (contactHostAndPort != null) {
            MessagingAddress contact;
            MessagingProvider provider = this.collector.getMessagingProvider();
            MessageReceiver receiver = this.collector.getMessageReceiver();
            try {
                contact = provider.getMessagingAddress(contactHostAndPort, contactPort);
            }
            catch (IllegalArgumentException e) {
                contact = provider.getMessagingAddress(contactHostAndPort, config.getContactPort());
            }
            NodeCollector r = StatFactory.getNodeCollector(config, contact, this.viz, receiver);
            Thread t = new Thread(r);
            t.setName("NodeCollector in Visualizer");
            t.setDaemon(true);
            t.start();
        }
    }

    private class VizCallback
    implements MessagingCallbackExtended {
        private VizCallback() {
        }

        public void messageSent(MessagingAddress source, MessagingAddress dest, int tag, int len) {
            ID sourceID = OverlayVisualizer.this.collector.getID(source);
            ID destID = OverlayVisualizer.this.collector.getID(dest);
            if (sourceID != null) {
                OverlayVisualizer.this.viz.addNode(sourceID, source);
                int sourceIDSizeInBit = sourceID.getSize() * 8;
                OverlayVisualizer.this.viz.setIDSizeInBit(sourceIDSizeInBit);
            }
            if (sourceID != null && destID != null) {
                OverlayVisualizer.this.viz.addMessage(sourceID, destID, tag);
            }
        }

        public void nodeFailed(MessagingAddress node) {
            ID id = OverlayVisualizer.this.collector.getID(node);
            if (id != null) {
                OverlayVisualizer.this.viz.removeNode(id);
            }
        }

        public void emphasizeNode(ID nodeID) {
            OverlayVisualizer.this.viz.emphasizeNode(nodeID);
        }

        public void markID(ID id, int hint) {
            OverlayVisualizer.this.viz.addMark(id, hint);
        }

        public void connectNodes(ID from, ID to, int colorHint) {
            OverlayVisualizer.this.viz.connectNodes(from, to, colorHint);
        }

        public void disconnectNodes(ID from, ID to, int colorHint) {
            OverlayVisualizer.this.viz.disconnectNodes(from, to, colorHint);
        }
    }
}

