/*
 * Copyright 2007,2009 Kazuyuki Shudo, and contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ow.directory.expiration;

/**
 * A value type for {@link ExpiringSingleValueDirectory ExpiringSingleValueDirectory}
 * and {@link ExpiringMultiValueDirectory ExpiringMultiValueDirectory}
 * can implement this interface.
 * If the type implements this interface, TTL in a value is automatically maintained.
 */
public interface Expirable {
	int setTTL(int ttl);
	int getTTL();
}
