package spike.ex.source;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

import spike.ex.event.StateChangeEvent;
import spike.ex.listener.StateGUI;

public class EventExecuter {
	/* the self */
	private static EventExecuter source;
	public static void main(String[] args) {
		source = new EventExecuter();
		source.execute();

	}

	/**
	 * s
	 */
	public void execute() {
		/* set listener */
		this.addActionListener(new StateGUI());

		/* event occurs */
		// StateChangeEvent extends ActionEvent so,
		// it has neccesary arg ( int = Component ID ).
		this.sendActionEvent(new StateChangeEvent(this, StateChangeEvent.INIT, "܂"));
		this.sendActionEvent(new StateChangeEvent(this, 0, "begin"));
		this.sendActionEvent(new StateChangeEvent(this, 0, "get"));
		this.sendActionEvent(new StateChangeEvent(this, 0, "put"));
		this.sendActionEvent(new StateChangeEvent(this, 0, "stop"));
	}

	private Vector<ActionListener> listeners_ = new Vector<ActionListener>();

	/**
	 * Cxg
	 * @param evt - CӃCxg
	 */
	@SuppressWarnings("unchecked")
	private void sendActionEvent(ActionEvent evt) {
		// java.util.Vector has synchronized methods
		Vector<ActionListener> listeners = (Vector<ActionListener>) listeners_.clone();
		Enumeration<ActionListener> e = listeners.elements();
		while (e.hasMoreElements()) {
			ActionListener listener = e.nextElement();
			listener.actionPerformed(evt);
		}
	}

	public void addActionListener(ActionListener l) {
		this.listeners_.addElement(l);
	}

	public void removeActionListener(ActionListener l) {
		this.listeners_.removeElement(l);
	}

}
