/*
 * Copyright (C) 2010-2011 OgakiSoft.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
#include "ogakisoft_android_svm_SvmWrapper.h"
#include <jni.h>
#include <android/log.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define  LOG_TAG    "svm_wrapper"
#define  LOGI(...)  __android_log_print(ANDROID_LOG_INFO,LOG_TAG,__VA_ARGS__)
#define  LOGW(...)  __android_log_print(ANDROID_LOG_WARN,LOG_TAG,__VA_ARGS__)
#define  LOGE(...)  __android_log_print(ANDROID_LOG_ERROR,LOG_TAG,__VA_ARGS__)

int svm_scale_main(int argc, char **argv);
int svm_train_main(int argc, char **argv);
int svm_predict_main(int argc, char **argv);
void init(JNIEnv *env, jobjectArray array);
void finish(void);
char** argv;
static int size_x = 20, size_y = 100;

/*
 * Class:     ogakisoft_android_svm_SvmWrapper
 * Method:    scale
 * Signature: ([Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_ogakisoft_android_svm_SvmWrapper_scale
(JNIEnv *env, jclass thiz, jobjectArray array) {

	//	jclass clazz = (*env)->GetObjectClass(env, this);
	//	jfieldID fid = (*env)->GetFieldID(env, clazz, "pkgPrivateFieldInt", "I");
	//	jint val = (*env)->GetIntField(env, this, fid);

	init(env, array);
	svm_scale_main(sizeof(argv), argv);
	finish();
	return;
}

/*
 * Class:     ogakisoft_android_svm_SvmWrapper
 * Method:    train
 * Signature: ([Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_ogakisoft_android_svm_SvmWrapper_train
(JNIEnv *env, jclass thiz, jobjectArray array) {
	init(env, array);
	svm_train_main(sizeof(argv), argv);
	finish();
	return;
}

/*
 * Class:     ogakisoft_android_svm_SvmWrapper
 * Method:    predict
 * Signature: ([Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_ogakisoft_android_svm_SvmWrapper_predict
(JNIEnv *env, jclass thiz, jobjectArray array) {
	init(env, array);
	svm_predict_main(sizeof(argv), argv);
	finish();
	return;
}

void finish() {
	int i;
	for (i = 0; i < size_x; i++) {
		free(argv[i]);
	}
	free(argv);
}

void init(JNIEnv *env, jobjectArray array) {
	int i;
	argv = (char**) malloc(sizeof(char*) * size_x);
	for (i = 0; i < size_x; i++) {
		argv[i] = (char*) malloc(sizeof(char) * size_y);
	}
	jint ji;
	jint count = (*env)->GetArrayLength(env, array);
	for (i = 0; i < size_x; i++) {
		strcpy(argv[i], "");
	}
	for (ji = 0; ji < count; ji++) {
		jstring j_string = (*env)->GetObjectArrayElement(env, array, ji);
		char* words = (*env)->GetStringUTFChars(env, j_string, NULL) ;
		if ((*env)->ExceptionOccurred(env)) {
			LOGE("exception occurred:\n");
			break;
		}
		strcpy(argv[ji+1], words);
		LOGI("argv[%d]='%s'\n",ji+1,argv[ji+1]);
		(*env)->ReleaseStringUTFChars(env, j_string, words);
	}
//	strcpy(argv[0], "argv");
	return;
}

JNIEXPORT jint JNI_OnLoad(JavaVM *vm, void *reserved) {
	return JNI_VERSION_1_2;
}
