/*
 * Copyright (C) 2011 OgakiSoft
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ogakisoft.android.gestureime;

import java.io.File;

import ogakisoft.android.gestureime.R;
import ogakisoft.android.util.LOG;
import android.app.Activity;
import android.app.ProgressDialog;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

/**
 * Download dialog called when there are not data
 * 
 * @version 1.0
 * @author noritoshi ogaki
 */

//TODO [Uo^f[^΃Rs[Ė̂ύX
//TODO Ȃ΁AOo^f[^̂܂܎g
//TODO gesture_data -> gesture_data.0

public class DownloadActivity extends Activity {
	/** The site that download gesture data */
	private static final String FETCH_URL
		= "http://sites.google.com/site/ogakisoft/file-cabinet/gestureime_data.zip?attredirects=0&d=1";
	/** LOG tag */
	private static final String TAG = "DownloadActivity";
	/** for call-back at the end of task */
	private Handler mHandler;
	/** for waiting during task */
	private ProgressDialog mProgressDialog;
	/** An async task to download, and to extract it */
	private DownloadTask mTask1;

	public void onClickCancelButton(View v) {
		setResult(RESULT_CANCELED);
		finish();
	}

	public void onClickCloseButton(View v) {
		finish();
	}

	public void onClickGoButton(View v) {
		if (null != mTask1
				&& mTask1.getStatus() != DownloadTask.Status.FINISHED) {
			mTask1.cancel(true);
		}
		mTask1 = (DownloadTask) new DownloadTask(mHandler).execute(FETCH_URL);
		mProgressDialog.show();
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.download_activity);

		// check SDCARD
		final File f = Environment.getExternalStorageDirectory();
		if (!f.canRead() || !f.canWrite()) {
			LOG.e(TAG, getResources().getString(R.string.error_sdcard));
			final TextView text = (TextView) findViewById(R.id.text);
			text.setText(R.string.error_sdcard);
			final Button b1 = (Button) findViewById(R.id.goButton);
			// final Button b2 = (Button) findViewById(R.id.cancelButton);
			b1.setEnabled(false);
			// b2.setEnabled(false);
		}

		mProgressDialog = new ProgressDialog(DownloadActivity.this);
		mProgressDialog.setIndeterminate(true);
		mProgressDialog.setMessage(getResources().getString(
				R.string.message_downloading));

		/* finish a progress dialog by call-back */
		mHandler = new Handler() {
			public void handleMessage(android.os.Message msg) {
				final TextView text = (TextView) findViewById(R.id.text);
				if (null != mProgressDialog) {
					if (mProgressDialog.isShowing()) {
						mProgressDialog.dismiss();
					}
				}
				if (msg.what == DownloadTask.STATUS_SUCCESS) {
					setResult(RESULT_OK);
					text.setText(getResources().getString(
							R.string.message_download_success));
				} else {
					/* When an error occurred, display a message */
					setResult(RESULT_CANCELED);
					text.setText(getResources().getString(
							R.string.error_download));
				}
				final Button b1 = (Button) findViewById(R.id.goButton);
				final Button b2 = (Button) findViewById(R.id.cancelButton);
				final Button b3 = (Button) findViewById(R.id.closeButton);
				b1.setVisibility(View.INVISIBLE);
				b2.setVisibility(View.INVISIBLE);
				b3.setVisibility(View.VISIBLE);
			}
		};
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		if (null != mTask1
				&& mTask1.getStatus() != DownloadTask.Status.FINISHED) {
			mTask1.cancel(true);
			mTask1 = null;
		}
		mProgressDialog = null;
		mHandler = null;
	}
}