package ogakisoft.android.util;

public class Vector {
	private static final String TAG = "Vector";
	public float x;
	public float y;

	public Vector(float x, float y) {
		this.x = x;
		this.y = y;
	}

	public Vector add(Vector v) {
		x += v.x;
		y += v.y;
		return this;
	}

	public Vector sub(Vector v) {
		x -= v.x;
		y -= v.y;
		return this;
	}

	// public float length() {
	// return (float) Math.sqrt(x * x + y * y);
	// }
	//
	//
	// public Vector normalize() {
	// float length = length();
	// if (length < 0.0001f)
	// length = 1.0f;
	// x /= length;
	// y /= length;
	// return this;
	// }


	// 丸め誤差 1^-10
	// private static final double EPS = Math.exp(-10);

	// 丸め誤差未満なら同じとみなす
	// private static int EQ(double a, double b) {
	// if (Math.abs((a) - (b)) < EPS) {
	// return 0; // consider equal
	// }
	// return 1;
	// }

	// private static Vector distance(Vector a, Vector b) {
	// Vector v = a.sub(b);
	// v.x = Math.abs(v.x);
	// v.y = Math.abs(v.y);
	// return v;
	// }

	// 2直線の直交判定 : a⊥b <=> dot(a, b) = 0
	// public static int isOrthogonal(Vector a1, Vector a2, Vector b1, Vector
	// b2) {
	// return EQ(Vector.dot(distance(a1, a2), distance(b1, b2)), 0.0);
	// }

	// 2直線の平行判定 : a//b <=> cross(a, b) = 0
	// public static int isParallel(Vector a1, Vector a2, Vector b1, Vector b2)
	// {
	// return EQ(Vector.cross(distance(a1, a2), distance(b1, b2)), 0.0);
	// }

	// 線分の交差判定
	// public static int isIntersect(Vector a1, Vector a2, Vector b1, Vector b2)
	// {
	// double a = Vector.cross(a2.sub(a1), b1.sub(a1))
	// * Vector.cross(a2.sub(a1), b2.sub(a1));
	// double b = Vector.cross(b2.sub(b1), a1.sub(b1))
	// * Vector.cross(b2.sub(b1), a2.sub(b1));
	// if (a < 0 && b < 0)
	// return 0; // true
	// return 1;
	// }

	// 点cが線分a,bとその延長上にあるかないか
	// public static int isPointOnLine(Vector a, Vector b, Vector c) {
	// return EQ(Vector.cross(b.sub(a), c.sub(a)), 0.0);
	// }

	// ベクトルのなす角
	public static float angle(float[] points) {
		// Vector[] v = {a,b};
		// double theta = Math.acos(dot(a, b) / norm(v));
		// double theta = Math.atan2(cross(a, b), dot(a, b));
		// LOG(TAG, "angle: theta={0,number,#.#####}", theta);
		// float degree = (float) ((theta * 180.0) / Math.PI);
		// return degree;
		// return (float) theta;
		return 0;
	}

	// Heron's formula
	// public static double angle(Vector a1, Vector a2, Vector b1, Vector b2) {
	// double da = Math.sqrt(Math.pow(a2.x - a1.x, 2)
	// + Math.pow(a2.y - a1.y, 2));
	// double db = Math.sqrt(Math.pow(b2.x - b1.x, 2)
	// + Math.pow(b2.y - b1.y, 2));
	// double dc = Math.sqrt(Math.pow(b2.x - a1.x, 2)
	// + Math.pow(b2.y - a1.y, 2));
	// double s = (da + db + dc) / 2;
	// double S = Math.sqrt(s * (s - da) * (s - db) * (s - dc));
	// double h = (2 * S) / da;
	// // double B = Math.asin(h / dc);
	// double C = Math.asin(h / db);
	// return Math.round(C * 180.0 / Math.PI);
	// }

	// public static final void LOG(String tag, String format, Object... obj) {
	// final String msg = MessageFormat.format(format, obj);
	// System.out.println(tag + " " + msg);
	// }

	public static int straightness(float[] points) {
		double result = 0;
		// in the x-axis
		int count = points.length;
		double theta = 0d;
		Vector a, b;
		for (int i = 0; i < count && (i + 4 < count); i += 4) {
			a = new Vector(points[i], points[i + 1]);
			b = new Vector(points[i + 2], points[i + 3]);
			// theta = Math.atan2(cross(a, b), dot(a, b));
			theta = Math.acos(dot(a, b) / norm(a, b));
			LOG.d(TAG, "straightness: {0,number,#.###}", theta);
			// result += theta * (180 / Math.PI);
		}
		return 0;
	}

	// 外積
	private static double cross(Vector v1, Vector v2) {
		return v1.x * v2.y - v1.y * v2.x;
	}

	// 内積
	private static double dot(Vector v1, Vector v2) {
		return v1.x * v2.x + v1.y * v2.y;
	}

	private static double norm(Vector v1, Vector v2) {
		Vector[] v = { v1, v2 };
		return norm(v);
	}

	private static float norm(Vector[] v) {
		float sum = 0.0f;
		int count = v.length;
		for (int i = 0; i < count; i++) {
			sum += v[i].x * v[i].x + v[i].y * v[i].y;
		}
		return (float) Math.sqrt(sum);
	}
}
