package ogakisoft.gesture.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

/**
 * Convert gesture-data to R table
 * 
 * @author noritoshi ogaki
 */

public class RConverter {
    static final String PATH = "/Users/ogakinoritoshi/Documents/workbench/gestureime_libsvm_input";

    /**
     * @param args
     */
    public static void main(String[] args) {
	// gesture-data format
	// label index:x index:y index:x index:y ...
	// if (args.length != 1) {
	// System.out.println("Usage: RTable file");
	// return;
	// }
	String filepath = PATH;
	BufferedReader br = null;
	BufferedWriter bw = null;
	try {
	    br = new BufferedReader(new FileReader(filepath));
	    bw = new BufferedWriter(new FileWriter(filepath + ".rt"));
	} catch (FileNotFoundException e) {
	    e.printStackTrace();
	} catch (IOException e) {
	    e.printStackTrace();
	}
	try {
	    String line = null;
	    String[] array;
	    int array_length = 0;
	    while ((line = br.readLine()) != null) {
		array = line.split(" ");
		bw.write(array[0] + " ");
		int count = array.length;
		for (int i = 1; i < count; i++) {
		    String s = array[i].substring(array[i].indexOf(':') + 1);
		    bw.write(s + " ");
		}
		array_length = Math.max(array_length, count);
		for(count = array_length - count; count > 0; count--) {
		    bw.write("0.0 ");
		}
		bw.newLine();
	    }
	} catch (IOException e) {
	    e.printStackTrace();
	} finally {
	    try {
		bw.close();
		br.close();
	    } catch (IOException e) {
		e.printStackTrace();
	    }
	}
    }
}
