/*
 * Copyright (C) 2011 OgakiSoft
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package ogakisoft.util;

import java.text.MessageFormat;

/**
 * This class outputs a message in log
 * 
 * @author noritoshi ogaki
 * @version 1.0
 */
public class LOG {
	/**
	 * Level e (error message) log
	 * 
	 * @param tag
	 *            String
	 * @param format
	 *            String
	 * @param obj
	 *            Object[]
	 */
	public static final void e(String tag, String format, Object... obj) {
		final String msg = MessageFormat.format(format, obj);
		// Log.e(tag, msg);
		System.err.println(tag + " " + msg);
	}

	/**
	 * Level d (debug message) log
	 * 
	 * @param tag
	 *            String
	 * @param format
	 *            String
	 * @param obj
	 *            Object[]
	 */
	public static final void d(String tag, String format, Object... obj) {
		final String msg = MessageFormat.format(format, obj);
		// Log.d(tag, msg);
		System.err.println(tag + " " + msg);
	}
}
