package org.ginkgo.gcov.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.xml.sax.helpers.DefaultHandler;

public class LineCoverageParser implements IParser {
	
	public static final String UNCOVER_MARKER_TYPE = "org.ginkgo.gcov.lineUnCoverMarker";
	public static final String COVER_MARKER_TYPE = "org.ginkgo.gcov.lineCoverMarker";
	public static final String COVERAGE_MARKER_TYPE = "org.ginkgo.gcov.CoverageMarker";
	
	private String consoleName = "onsole";
	private IFile sourceFile = null;
	
	private class MyResourceVisitor implements IResourceVisitor{
		private String sourceFileName;

		private MyResourceVisitor(String FileName){			
			sourceFileName = FileName;
		}
		public boolean visit(IResource resource) throws CoreException {
			if(resource.getName().equals(sourceFileName)){
				sourceFile = (IFile)resource;
//				System.out.println(sourceFile);
				return false;
			}else{
//				System.out.println(resource);
				return true;
			}
		}
		
	}
	private MessageConsole getConsole() {
		IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
		IConsole[] consoles = manager.getConsoles();
		MessageConsole messageConsole = null;
		for (IConsole console : consoles) {
			if(console.getName().equals(consoleName)){
				messageConsole = (MessageConsole) console;
				break;
			}
		}
		if(messageConsole == null){
			messageConsole = new MessageConsole(consoleName, null);
		}
		manager.addConsoles(new IConsole[] {messageConsole});
		return messageConsole;
	}
	public void parse(IFile file) {
		String lineNum = null;
		String execCount = null;
		String line = null;
		sourceFile = null;
//		MessageConsole console = getConsole();
//		MessageConsoleStream commandStream = console.newMessageStream();
//		commandStream.setActivateOnWrite(true);
		
		IProject project = file.getProject();
		String sourceFileName = file.getName().replaceAll("\\.gcov", "");
		try {
			project.accept(new MyResourceVisitor(sourceFileName));
		} catch (CoreException e1) {
			// TODO ꂽ catch ubN
			e1.printStackTrace();
		}
//		sourceFile = (IFile) project.findMember(); //;
//		try {
//			sourceFile.refreshLocal(IResource.DEPTH_ZERO,null);
//		} catch (CoreException e1) {
//			// TODO
//			e1.printStackTrace();
//		}
		System.out.println(sourceFile);
		if(sourceFile==null){
			System.out.println("null!!");
			return;
		}
		deleteMarkers(sourceFile);
		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(file.getContents()));
			while((line = in.readLine())!=null){
				String[] s = line.split(":");
//				commandStream.println(line);
//				System.out.println(line);
				if(s.length ==3){
					execCount = s[0].trim();
					lineNum = s[1].trim();
					if(execCount.equals("#####")){
						Map attributes = new HashMap();
						MarkerUtilities.setMessage(attributes,"Not Covered");
						MarkerUtilities.setLineNumber(attributes, Integer.parseInt(lineNum));
						MarkerUtilities.createMarker(sourceFile, attributes, UNCOVER_MARKER_TYPE);
					}else if(execCount.equals("-")){

					}else{
						Map attributes = new HashMap();
						MarkerUtilities.setMessage(attributes,execCount);
						MarkerUtilities.setLineNumber(attributes, Integer.parseInt(lineNum));
						MarkerUtilities.createMarker(sourceFile, attributes, COVER_MARKER_TYPE);
					}
					continue;
				}
			}
//			System.out.println("marker fin");			
		} catch (NumberFormatException e) {
			// TODO
			e.printStackTrace();
		} catch (IOException e) {
			// TODO
			e.printStackTrace();
		}
		catch (CoreException e) {
			// TODO
			e.printStackTrace();
		}
	}

	public static void deleteMarkers(IFile file) {
		try {
			file.deleteMarkers(COVER_MARKER_TYPE, true, IResource.DEPTH_ZERO);
			file.deleteMarkers(UNCOVER_MARKER_TYPE, true, IResource.DEPTH_ZERO);
		} catch (CoreException ce) {
		}
	}


}
