/*
 * Created on 2008/06/08
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package org.ginkgo.gcov.navigator;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class CoverageLabelProvider extends LabelProvider implements ITableLabelProvider {
	LabelProvider provider;
	
	public CoverageLabelProvider(IBaseLabelProvider provider) {
		if (provider instanceof LabelProvider) {
			this.provider = (LabelProvider) provider;
			
		}
	}

	public Image getColumnImage(Object element, int columnIndex) {
		if (columnIndex == 0) {
			return provider.getImage(element);
		}
		return null;
	}

	public String getColumnText(Object element, int columnIndex) {
		if (columnIndex == 0) {
			return provider.getText(element);
		}
		return createCoverageInformationText(element);
	}


	public String createCoverageInformationText(Object element) {
		int totalLine = 133;
		//int coverage = (coverLine*100)/totalLine;
		int coverLine = 20;
		float coverage = 0;
		if (element instanceof ICElement) {
			ICElement a = (ICElement) element;
			try {
				IProject p = a.getCProject().getProject();
				String n = a.getElementName();
				totalLine = Integer.parseInt(p.getPersistentProperty(new QualifiedName(n,"totalLine")));
				coverage = Float.parseFloat(p.getPersistentProperty(new QualifiedName(n,"persent")));
				coverLine = (int) (totalLine * coverage /100);
				}
			catch (NumberFormatException e){
				coverLine = 0;
				return "";
			} catch (CoreException e) {
				// TODO �����������ꂽ catch �u���b�N
				e.printStackTrace();
			}
		}else{
			return "";
		}
		String str = String.format("%6.2f %% [ %3d / %3d ]", coverage,coverLine,totalLine);
		
		return str;
	}
}
