#ifndef GINTENLIB_INCLUDED_DESTRUCTOR_HPP_
#define GINTENLIB_INCLUDED_DESTRUCTOR_HPP_

/*

      <gintenlib/destructor.hpp>

  destructor ： デストラクタ呼び出しと等価なファンクタ
  typed_destructor ： 型の指定された destructor

  機能：
    デストラクタ呼び出し用の関数オブジェクトです。それ以外の何物でもありません。
    deleter は boost::checked_delete を呼んでますが、この中では単に delete 演算子を呼んでいるだけ。
    dummy_deleter は delete 演算子すら呼ばない、単なるプレースホルダーとして機能します。
    それぞれ型付バージョンもあり、それらは unary_function の条件を満たしています。

*/

#include <functional>
#include <boost/checked_delete.hpp>

namespace gintenlib
{
  // デストラクタを呼び出すファンクタ
  struct destructor
  {
    typedef void result_type;
    
    template<typename T>
    void operator()( T* p ) const
    {
      p->~T();
    }
    
  };  // struct destructor
  
  // 型の束縛された destructor
  template<typename T>
  struct typed_destructor
    : std::unary_function<T*, void>
  {
    void operator()( T* p ) const
    {
      destructor().operator()<T>( p );
    }
  
  };  // struct typed_destructor<T>

}   // namespace gintenlib

#endif  // #ifndef GINTENLIB_INCLUDED_DESTRUCTOR_HPP_
