#ifndef GINTENLIB_INCLUDED_IDENTITY_HPP_
#define GINTENLIB_INCLUDED_IDENTITY_HPP_

/*

      <gintenlib/identity.hpp>

  identity ： boost::call_traits ＋ boost::mpl::identity

  宣言：
    template<typename T>
    struct identity
      : boost::call_traits<T>
    {
      typedef T type;
    };

  機能：
    boost::call_traits に「与えられた型をそのまま返す」メタ関数の機能を加えたものです。
    reference や param_type の取得もしたいし、メタ関数としても使いたい、なんて局面で使います。
    実装補助用です。

*/

#include "call_traits.hpp"

namespace gintenlib
{
  // gintenlib::identity = boost::call_traits + boost::mpl::identity
  template<typename T>
  struct identity
    : call_traits<T>
  {
    typedef T type;
  };

}   // namespace gintenlib


#endif  // #ifndef GINTENLIB_INCLUDED_IDENTITY_HPP_
