#ifndef GINTENLIB_INCLUDED_MATH_HPP_
#define GINTENLIB_INCLUDED_MATH_HPP_

/*
      <gintenlib/math.hpp>

  math ： M_PI といった定数マクロを確実に #define してくれる <cmath> ヘッダ

  機能：
    <cmath> ヘッダは実装によって各種数学定数が define されない場合があるので、
    そういう場合に対応するためのヘッダです。
    各定数の意味はそれぞれのコメントを参照してください。

*/

#include <cmath>

// 自然対数の底 e
#ifndef M_E
#define M_E        2.71828182845904523536
#endif

// log2(e)
#ifndef M_LOG2E
#define M_LOG2E    1.44269504088896340736
#endif

// log10(e)
#ifndef M_LOG10E
#define M_LOG10E   0.434294481903251827651
#endif

// ln(2)
#ifndef M_LN2
#define M_LN2      0.693147180559945309417
#endif

// ln(10)
#ifndef M_LN10
#define M_LN10     2.30258509299404568402
#endif

// 円周率π
#ifndef M_PI
#define M_PI       3.14159265358979323846
#endif

// π / 2
#ifndef M_PI_2
#define M_PI_2     1.57079632679489661923
#endif

// π / 4
#ifndef M_PI_4
#define M_PI_4     0.785398163397448309616
#endif

// 1 / π
#ifndef M_1_PI
#define M_1_PI     0.318309886183790671538
#endif

// 2 / π
#ifndef M_2_PI
#define M_2_PI     0.636619772367581343076
#endif

// 2 / sqrt(π)
#ifndef M_2_SQRTPI
#define M_2_SQRTPI 1.12837916709551257390
#endif

// sqrt(2)
#ifndef M_SQRT2
#define M_SQRT2    1.41421356237309504880
#endif

// sqrt(1/2)
#ifndef M_SQRT1_2
#define M_SQRT1_2  0.707106781186547524401
#endif


#endif  // #ifndef GINTENLIB_INCLUDED_MATH_HPP_
