// ヘッダのインクルード
#include "../gintenlib/preprocessor/enable_if.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

// テストに使うクラス
struct base {};
struct derived : base {};

// テストに使うメタ関数
#include <boost/type_traits/is_base_of.hpp>

// GINTENLIB_ENABLE_IF のチェック
// これさえ通れば、この内部で使われている
// <gintenlib/enable_if.hpp>
// <gintenlib/d_enable_if.hpp>
// <gintenlib/preprocessor/dequote.hpp>
// これらのチェックも自動的に通ったことになる
template<typename T>
bool hoge( const T&,  GINTENLIB_ENABLE_IF(( boost::is_base_of<base, T> )) )
{
  return true;
}
template<typename T>
bool hoge( const T&, GINTENLIB_DISABLE_IF(( boost::is_base_of<base, T> )) )
{
  return false;
}


// 単体テスト本体
int test_main( int, char** )
{
  derived d;
  int i;
  
  BOOST_CHECK(  hoge(d) );
  BOOST_CHECK( !hoge(i) );
  
  return 0;
}
