#include "../gintenlib/identity.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

// boost の該当ヘッダをインクルード
#include <boost/mpl/identity.hpp>
#include <boost/call_traits.hpp>

#include <boost/mpl/assert.hpp>
#include <boost/type_traits/is_same.hpp>

// 二つの型が「等しい」ことをコンパイル時＆一応実行時にチェックする
template<typename T1, typename T2>
bool is_equal()
{
  BOOST_MPL_ASSERT(( boost::is_same<T1, T2> ));
  return boost::is_same<T1, T2>::value;
}

// 型 T に対して動作をチェックする
template<typename T>
void test()
{
  // gintenlib::identity<T>::type は T 自身に等しい
  BOOST_CHECK(( is_equal<T, typename gintenlib::identity<T>::type>() ));
  
  // value_type, param_type, reference, const_reference は、boost::call_traits と同じ
  #define GEN_TEST_( xxx )  \
    BOOST_CHECK(( is_equal<typename boost::call_traits<T>::xxx, \
      typename gintenlib::identity<T>::xxx >() ));
  
    GEN_TEST_( value_type );
    GEN_TEST_( param_type );
    GEN_TEST_( reference );
    GEN_TEST_( const_reference );
    
  #undef GEN_TEST_
}

#include <iostream>

int test_main( int, char** )
{
  // 組み込み型
  test<int>();
  // オブジェクト
  test<std::ostream>();
  // ポインタ
  test<int*>();
  // 参照
  test<std::ostream&>();
    
  return 0;
}
