// ヘッダ
#include "../gintenlib/intrusive_ptr_hook.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

// これがないとテストしようがない
#include <boost/intrusive_ptr.hpp>

// 通常版
struct simple
  : gintenlib::intrusive_ptr_hook<simple>
{
  static int instances;
  
  simple() { ++instances; }
  simple( simple const& src ) : gintenlib::intrusive_ptr_hook<simple>(src) { ++instances; }
  ~simple() throw () { --instances; }
  
  int use_count() const
  {
    return intrusive_ptr_use_count( this );
  }
  
};
int simple::instances = 0;

void simple_test()
{
  BOOST_CHECK( simple::instances == 0 );
  {
    // 通常の生成と破棄
    simple const x;
    
    BOOST_CHECK( simple::instances == 1 );
    BOOST_CHECK( x.use_count() == 0 );
  }
  BOOST_CHECK( simple::instances == 0 );
  {
    // 本番
    boost::intrusive_ptr<simple const> p1( new simple ), p2( new simple );
    
    BOOST_CHECK( simple::instances == 2 );
    BOOST_CHECK( p1->use_count() == 1 );
    BOOST_CHECK( p2->use_count() == 1 );
    
    // 移動させてカウントを変化させる
    p2 = p1;
    
    BOOST_CHECK( simple::instances == 1 );
    BOOST_CHECK( p1->use_count() == 2 );
    BOOST_CHECK( p2->use_count() == 2 );
  }
  BOOST_CHECK( simple::instances == 0 );
}

// 複雑な例
class compound;
// 削除子（状態を持つ）
// 例なのでシンプルに、int を持たせただけのデリータを使う
struct compound_deleter
{
  compound_deleter()
    : x() {}
  explicit compound_deleter( int x_ )
    : x( x_ ) {}

  template<typename T>
  void operator()( T* p )
  {
    delete p;
  }

  int x;
};

struct compound
  : gintenlib::intrusive_ptr_hook<compound, compound_deleter>
{
  typedef gintenlib::intrusive_ptr_hook<compound, compound_deleter> base;
  static int instances;
  
  compound() { ++instances; }
  compound( compound const& src ) : base(src) { ++instances; }
  ~compound() throw () { --instances; }
  
  int use_count() const
  {
    return intrusive_ptr_use_count( this );
  }

  int  x() const { return base::get_deleter().x; }
  int& x()       { return base::get_deleter().x; }

};
int compound::instances = 0;

void compound_test()
{
  BOOST_CHECK( compound::instances == 0 );
  {
    // 通常の生成と破棄
    compound x;
    
    BOOST_CHECK( compound::instances == 1 );
    BOOST_CHECK( x.use_count() == 0 );

    // コピー（削除子はコピーされないことを確認）
    x.x() = 13;
    compound const y = x;
    BOOST_CHECK( x.x() == 13 );
    BOOST_CHECK( y.x() ==  0 );
  }
  BOOST_CHECK( compound::instances == 0 );
  {
    // 本番
    boost::intrusive_ptr<compound const> p1( new compound ), p2( new compound );
    
    BOOST_CHECK( compound::instances == 2 );
    BOOST_CHECK( p1->use_count() == 1 );
    BOOST_CHECK( p2->use_count() == 1 );
    
    // 移動させてカウントを変化させる
    p2 = p1;
    
    BOOST_CHECK( compound::instances == 1 );
    BOOST_CHECK( p1->use_count() == 2 );
    BOOST_CHECK( p2->use_count() == 2 );
  }
  BOOST_CHECK( compound::instances == 0 );
}

int test_main( int, char** )
{
  simple_test();
  compound_test();
  
  return 0;
}

