#include "../gintenlib/list_format.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

#include <sstream>
#include <vector>

using namespace std;

// 空のコンテナに対するテスト
// 空コンテナに対しては何も出力されない
template<typename T>
bool is_empty( const T& x )
{
  ostringstream oss;
  oss << x;
  
  return oss.str() == "";
}
void test_empty()
{
  vector<int> v;
  using gintenlib::list_format;
  
  // 四通り全ての呼び出しパターンでテストする
  BOOST_CHECK( is_empty( list_format( v ) ) );
  BOOST_CHECK( is_empty( list_format( v.begin(), v.end() ) ) );
  BOOST_CHECK( is_empty( list_format( v, "hoge", "fuga", "piyo" ) ) );
  BOOST_CHECK( is_empty( list_format( v.begin(), v.end(),
    string("hoge"), 23, '\n' ) ) ); // 区切りは char* じゃなくてもおｋ
}

// 基本的なテスト
void test_basic()
{
  // とりあえずデータを用意する
  vector<int> v;
  v.push_back( 0 );
  v.push_back( 6 );
  v.push_back( 1 );
  v.push_back( 7 );
  
  {
    // 基本的な出力
    ostringstream oss;
    oss << gintenlib::list_format( v );
    BOOST_CHECK( oss.str() == "( 0, 6, 1, 7 )" );
  }
  {
    // イテレータ２つによる範囲指定
    ostringstream oss;
    oss << gintenlib::list_format( v.rbegin(), v.rend() );
    BOOST_CHECK( oss.str() == "( 7, 1, 6, 0 )" );
  }
  {
    // スタイルを変化させてみよう
    ostringstream oss;
    oss << gintenlib::list_format( v, "", ' ', "" );  // 区切りには任意の型が指定できる
    BOOST_CHECK( oss.str() == "0 6 1 7" );
  }
  {
    // スタイル変化＋イテレータ範囲指定
    ostringstream oss;
    oss << gintenlib::list_format( v.begin(), v.end(), '[', '|', ']' );
    BOOST_CHECK( oss.str() == "[0|6|1|7]" );
  }
}

int test_main( int, char** )
{
  // 空 range に対するチェック
  test_empty();
  
  // 基本的なテスト
  test_basic();
  
  return 0;
}
