#include "../gintenlib/memberwise_swap.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

#include <string>
#include <boost/scoped_ptr.hpp>

// 使用例（面倒なのでメンバ３個ので代表する）
struct hoge
{
  // 内部データ構造体とか
  struct data
  {
    explicit data( int x_ )
      : x(x_){}
    
    int x;
  };
  
  int i;                      // 組み込み型 
  std::string s;              // assignable なクラス
  boost::scoped_ptr<data> p;  // noncopyable かつ swappable なクラス
  
  hoge( int i_, const std::string& s_, int x )
    : i( i_ ), s( s_ ), p( new data(x) ) {}
  
  // 本体
  void swap( hoge& other )
  {
    // 交換したい２オブジェクトに続けて、メンバ変数へのポインタを並べる
    gintenlib::memberwise_swap( *this, other, &hoge::i, &hoge::s, &hoge::p );
  }
  friend void swap( hoge& one, hoge& another )
  {
    one.swap( another );
  }
  
};  // struct hoge

// テスト本体
int test_main( int, char** )
{
  hoge h1( 1, "foo", 23 ), h2( 2, "bar", 42 );
  hoge::data *p1 = h1.p.get(), *p2 = h2.p.get();
  
  // swap 呼び出し
  swap( h1, h2 );
  
  // 交換出来ているかチェック
  BOOST_CHECK( h1.i == 2        && h2.i == 1        );
  BOOST_CHECK( h1.s == "bar"    && h2.s == "foo"    );
  BOOST_CHECK( h1.p.get() == p2 && h2.p.get() == p1 );
  
  return 0;
}
