#include "../gintenlib/ptr_fun.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

#include <boost/format.hpp>
#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/make_shared.hpp>

// テスト関数１
// 任意の引数をカンマ区切りで文字列化する
struct functor1
  : private boost::noncopyable
{
  typedef std::string result_type;
  
  template<typename Arg1>
  result_type operator()( const Arg1& arg1 )
  {
    return ( boost::format("%1%") % arg1 ).str();
  }
  template<typename Arg1, typename Arg2>
  result_type operator()( const Arg1& arg1, const Arg2& arg2 )
  {
    return ( boost::format("%1%, %2%") % arg1 % arg2 ).str();
  }
};

void test1()
{
  boost::shared_ptr<functor1> p = boost::make_shared<functor1>();
  gintenlib::indirect_function< boost::shared_ptr<functor1> > f = gintenlib::ptr_fun(p);
  
  BOOST_CHECK( f.get_pointer() == p );
  BOOST_CHECK( &f.get_function() == p.get() );
  
  BOOST_CHECK( f(1) == "1" );
  BOOST_CHECK( f(1, "hoge") == "1, hoge" );
}

// テスト関数２（result_type なし）
struct functor2
  : private boost::noncopyable
{
  template<typename T>
  T operator()( T x )
  {
    return ++x;
  }
};

void test2()
{
  boost::shared_ptr<functor2> p = boost::make_shared<functor2>();
  gintenlib::indirect_function< boost::shared_ptr<functor2>, int > f(p);
  
  BOOST_CHECK( f.get_pointer() == p );
  BOOST_CHECK( &f.get_function() == p.get() );
  
  BOOST_CHECK( f(1) == 2 );
}


// テスト本体
int test_main( int, char** )
{
  test1();
  test2();
  
  return 0;
}
