/*
 * Decompiled with CFR 0.152.
 */
package jp.co.olympus.camerakit;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.olympus.camerakit.OLYCamera;
import jp.co.olympus.camerakit.OLYCameraKitException;
import jp.co.olympus.camerakit.OLYCameraLog;
import jp.co.olympus.camerakit.h;
import jp.co.olympus.camerakit.internal.g;
import jp.co.olympus.camerakit.k;
import jp.co.olympus.camerakit.l;

public class OLYCameraRecordingSupportsTrait {
    private OLYCamera.j a;
    private boolean b = false;
    private boolean c = false;

    public boolean isDrivingZoomLens() {
        return this.b;
    }

    public boolean isMagnifyingLiveImage() {
        return this.c;
    }

    protected OLYCameraRecordingSupportsTrait(OLYCamera.j adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        if (!(adapter instanceof OLYCamera.j)) {
            throw new IllegalAccessError();
        }
        this.a = adapter;
    }

    public void start() {
        this.b = false;
        this.c = false;
    }

    public void stop() {
        this.b = false;
        this.c = false;
    }

    public void startDrivingZoomLensForDirection(OLYCamera.DrivingZoomLensDirection direction, OLYCamera.DrivingZoomLensSpeed speed) throws OLYCameraKitException {
        OLYCameraLog.i("direction=%s, speed=%s", new Object[]{direction, speed});
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        final String cgiDir = (String)new EnumMap<OLYCamera.DrivingZoomLensDirection, String>(OLYCamera.DrivingZoomLensDirection.class){
            {
                this.put(OLYCamera.DrivingZoomLensDirection.Wide, "wide");
                this.put(OLYCamera.DrivingZoomLensDirection.Tele, "tele");
            }
        }.get((Object)direction);
        if (cgiDir == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'direction' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        final String cgiMethod = (String)new EnumMap<OLYCamera.DrivingZoomLensSpeed, String>(OLYCamera.DrivingZoomLensSpeed.class){
            {
                this.put(OLYCamera.DrivingZoomLensSpeed.Slow, "contslow");
                this.put(OLYCamera.DrivingZoomLensSpeed.Fast, "contfast");
                this.put(OLYCamera.DrivingZoomLensSpeed.Normal, "contnormal");
                this.put(OLYCamera.DrivingZoomLensSpeed.Burst, "burst");
            }
        }.get((Object)speed);
        if (cgiMethod == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'speed' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is not performing the shooting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (this.b) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is not driving the zoom lens.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new Callable<Void>(){

                public Void a() throws Exception {
                    String result;
                    try {
                        result = OLYCameraRecordingSupportsTrait.this.a.a(new OLYCamera.c<String, h>(){

                            @Override
                            public String a(h value) throws Exception {
                                return value.a(cgiDir, cgiMethod, 10.0);
                            }
                        });
                    }
                    catch (Exception e2) {
                        OLYCameraKitException theException = new OLYCameraKitException(e2);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        throw theException;
                    }
                    if (!"OK".equals(result)) {
                        OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        throw theException;
                    }
                    OLYCameraRecordingSupportsTrait.this.b = true;
                    return null;
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void startDrivingZoomLensToFocalLength(final float focalLength) throws OLYCameraKitException {
        OLYCameraLog.i("focalLength=%f", Float.valueOf(focalLength));
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (focalLength <= 0.0f) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'focalLength' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is not performing the shooting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (this.b) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is not driving the zoom lens.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new Callable<Void>(){

                public Void a() throws Exception {
                    String result;
                    try {
                        result = OLYCameraRecordingSupportsTrait.this.a.a(new OLYCamera.c<String, h>(){

                            @Override
                            public String a(h value) throws Exception {
                                return value.a(focalLength, 10.0);
                            }
                        });
                    }
                    catch (Exception e2) {
                        OLYCameraKitException theException = new OLYCameraKitException(e2);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        throw theException;
                    }
                    if (!"OK".equals(result)) {
                        OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        throw theException;
                    }
                    OLYCameraRecordingSupportsTrait.this.b = true;
                    return null;
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void stopDrivingZoomLens() throws OLYCameraKitException {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is not performing the shooting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.b) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is driving the zoom lens.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new Callable<Void>(){

                public Void a() throws Exception {
                    String result;
                    try {
                        result = OLYCameraRecordingSupportsTrait.this.a.a(new OLYCamera.c<String, h>(){

                            @Override
                            public String a(h value) throws Exception {
                                return value.s(10.0);
                            }
                        });
                    }
                    catch (Exception e2) {
                        OLYCameraKitException theException = new OLYCameraKitException(e2);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        throw theException;
                    }
                    if (!"OK".equals(result)) {
                        OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        throw theException;
                    }
                    OLYCameraRecordingSupportsTrait.this.b = false;
                    return null;
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void onStopDrivingZoomLens() {
        this.a.a(new Runnable(){

            @Override
            public void run() {
                OLYCameraRecordingSupportsTrait.this.b = false;
                OLYCameraRecordingSupportsTrait.this.a.f();
            }
        });
    }

    public Map<String, Float> getDigitalZoomScaleRange() throws OLYCameraKitException {
        float maximumScale;
        float minimumScale;
        Map<String, Object> result;
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            result = this.a.a(new Callable<Map<String, Object>>(){

                public Map<String, Object> a() throws Exception {
                    return OLYCameraRecordingSupportsTrait.this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                        @Override
                        public Map<String, Object> a(h value) throws Exception {
                            return value.t(10.0);
                        }
                    });
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!result.containsKey("upper") || !result.containsKey("lower")) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        HashMap<String, Float> range = new HashMap<String, Float>();
        try {
            minimumScale = Float.parseFloat(result.get("lower").toString());
            maximumScale = Float.parseFloat(result.get("upper").toString());
        }
        catch (NumberFormatException e3) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        range.put("minimumZoomScale", Float.valueOf(minimumScale * 0.01f));
        range.put("maximumZoomScale", Float.valueOf(maximumScale * 0.01f));
        return range;
    }

    public void changeDigitalZoomScale(final float scale) throws OLYCameraKitException {
        String result;
        OLYCameraLog.i("scale=%f", Float.valueOf(scale));
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (scale <= 0.0f) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'scale' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (this.c) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera already entered live prevew enlarging mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            result = this.a.a(new Callable<String>(){

                public String a() throws Exception {
                    Map<String, Object> range = OLYCameraRecordingSupportsTrait.this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                        @Override
                        public Map<String, Object> a(h value) throws Exception {
                            return value.t(10.0);
                        }
                    });
                    if ((double)scale < (double)Float.parseFloat((String)range.get("lower")) * 0.01 || (double)scale > (double)Float.parseFloat((String)range.get("upper")) * 0.01) {
                        OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'scale' is invalid.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        throw theException;
                    }
                    return OLYCameraRecordingSupportsTrait.this.a.a(new OLYCamera.c<String, h>(){

                        @Override
                        public String a(h value) throws Exception {
                            return value.c((int)(scale * 100.0f), 10.0);
                        }
                    });
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!"OK".equals(result)) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void startMagnifyingLiveImage(OLYCamera.MagnifyingLiveViewScale scale) throws OLYCameraKitException {
        OLYCameraLog.i("scale=%s", new Object[]{scale});
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        EnumMap<OLYCamera.MagnifyingLiveViewScale, Float> map = new EnumMap<OLYCamera.MagnifyingLiveViewScale, Float>(OLYCamera.MagnifyingLiveViewScale.class){
            {
                this.put(OLYCamera.MagnifyingLiveViewScale.X5, Float.valueOf(5.0f));
                this.put(OLYCamera.MagnifyingLiveViewScale.X7, Float.valueOf(7.0f));
                this.put(OLYCamera.MagnifyingLiveViewScale.X10, Float.valueOf(10.0f));
                this.put(OLYCamera.MagnifyingLiveViewScale.X14, Float.valueOf(14.0f));
            }
        };
        if (!map.containsKey((Object)scale)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'scale' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        final float cgiScale = ((Float)map.get((Object)scale)).floatValue();
        if (this.c) {
            OLYCameraLog.w("The camera already entered live prevew enlarging mode.", new Object[0]);
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.b(cgiScale, 10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        this.c = true;
    }

    public void startMagnifyingLiveViewAtPoint(PointF point, OLYCamera.MagnifyingLiveViewScale scale) throws OLYCameraKitException {
        OLYCameraLog.i("point=%s, scale=%s", new Object[]{point, scale});
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        EnumMap<OLYCamera.MagnifyingLiveViewScale, Float> map = new EnumMap<OLYCamera.MagnifyingLiveViewScale, Float>(OLYCamera.MagnifyingLiveViewScale.class){
            {
                this.put(OLYCamera.MagnifyingLiveViewScale.X5, Float.valueOf(5.0f));
                this.put(OLYCamera.MagnifyingLiveViewScale.X7, Float.valueOf(7.0f));
                this.put(OLYCamera.MagnifyingLiveViewScale.X10, Float.valueOf(10.0f));
                this.put(OLYCamera.MagnifyingLiveViewScale.X14, Float.valueOf(14.0f));
            }
        };
        if (!map.containsKey((Object)scale)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'scale' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        final float cgiScale = ((Float)map.get((Object)scale)).floatValue();
        if (!new RectF(0.0f, 0.0f, 1.0f, 1.0f).contains(point.x, point.y)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'point' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (this.c) {
            OLYCameraLog.w("The camera already entered live prevew enlarging mode.", new Object[0]);
        }
        final Point cgiPoint = new Point((int)(point.x * (float)this.a.e().getWidth()), (int)(point.y * (float)this.a.e().getHeight()));
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.a(cgiScale, cgiPoint, 10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        this.c = true;
    }

    public void stopMagnifyingLiveView() throws OLYCameraKitException {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.c) {
            OLYCameraLog.w("The camera did no enter live prevew enlarging mode yet.", new Object[0]);
            return;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.M(10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        this.c = false;
    }

    public void changeMagnifyingLiveViewScale(OLYCamera.MagnifyingLiveViewScale scale) throws OLYCameraKitException {
        OLYCameraLog.i("scale=%s", new Object[]{scale});
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        EnumMap<OLYCamera.MagnifyingLiveViewScale, Float> map = new EnumMap<OLYCamera.MagnifyingLiveViewScale, Float>(OLYCamera.MagnifyingLiveViewScale.class){
            {
                this.put(OLYCamera.MagnifyingLiveViewScale.X5, Float.valueOf(5.0f));
                this.put(OLYCamera.MagnifyingLiveViewScale.X7, Float.valueOf(7.0f));
                this.put(OLYCamera.MagnifyingLiveViewScale.X10, Float.valueOf(10.0f));
                this.put(OLYCamera.MagnifyingLiveViewScale.X14, Float.valueOf(14.0f));
            }
        };
        if (!map.containsKey((Object)scale)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'scale' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        final float cgiScale = ((Float)map.get((Object)scale)).floatValue();
        if (!this.c) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered live prevew enlarging mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.c(cgiScale, 10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void changeMagnifyingLiveImageArea(OLYCamera.MagnifyingLiveViewScrollDirection direction) throws OLYCameraKitException {
        OLYCameraLog.i("direction=%s", new Object[]{direction});
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        EnumMap<OLYCamera.MagnifyingLiveViewScrollDirection, String> map = new EnumMap<OLYCamera.MagnifyingLiveViewScrollDirection, String>(OLYCamera.MagnifyingLiveViewScrollDirection.class){
            {
                this.put(OLYCamera.MagnifyingLiveViewScrollDirection.Up, "up");
                this.put(OLYCamera.MagnifyingLiveViewScrollDirection.Left, "left");
                this.put(OLYCamera.MagnifyingLiveViewScrollDirection.Right, "right");
                this.put(OLYCamera.MagnifyingLiveViewScrollDirection.Down, "down");
            }
        };
        if (!map.containsKey((Object)direction)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'direction' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        final String cgiScroll = (String)map.get((Object)direction);
        if (!this.c) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered live prevew enlarging mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.c(cgiScroll, 10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public Map<String, Object> getMagnifyingLiveViewArea() throws OLYCameraKitException {
        Map<String, Object> result;
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.c) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered live prevew enlarging mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            result = this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                @Override
                public Map<String, Object> a(h value) throws Exception {
                    return value.L(10.0);
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        HashMap<String, Object> treatedResult = new HashMap<String, Object>(result);
        if (!(treatedResult.containsKey("entiredomain") && treatedResult.containsKey("point") && treatedResult.containsKey("size"))) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        Point cgiOverallViewSize = OLYCameraRecordingSupportsTrait.a((String)treatedResult.get("entiredomain"));
        if (cgiOverallViewSize == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        Point cgiDisplayAreaPoint = OLYCameraRecordingSupportsTrait.a((String)treatedResult.get("point"));
        if (cgiDisplayAreaPoint == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        Point cgiDisplayAreaSize = OLYCameraRecordingSupportsTrait.a((String)treatedResult.get("size"));
        if (cgiDisplayAreaSize == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        treatedResult.put("_overallviewsize", cgiOverallViewSize);
        float x = (float)cgiDisplayAreaPoint.x / (float)cgiOverallViewSize.x;
        float y = (float)cgiDisplayAreaPoint.y / (float)cgiOverallViewSize.y;
        float w = (float)cgiDisplayAreaSize.x / (float)cgiOverallViewSize.x;
        float h2 = (float)cgiDisplayAreaSize.y / (float)cgiOverallViewSize.y;
        treatedResult.put("_displayarearect", new RectF(x, y, x + w, y + h2));
        return treatedResult;
    }

    public void downloadLastCapturedImage(final OLYCamera.DownloadImageCallback callback) {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                g image = null;
                try {
                    image = OLYCameraRecordingSupportsTrait.this.a.a(new OLYCamera.c<g, h>(){

                        @Override
                        public g a(h value) throws Exception {
                            return value.a(60.0, new l(){

                                @Override
                                public void a(k e2) {
                                    if (callback != null) {
                                        OLYCamera.ProgressEvent progressEvent = new OLYCamera.ProgressEvent(e2.b(), e2.c());
                                        callback.onProgress(progressEvent);
                                        if (progressEvent.a()) {
                                            OLYCameraLog.w("Cancel downloading an image.", new Object[0]);
                                            e2.e();
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Exception e2) {
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (image == null) {
                    throw new AssertionError();
                }
                if (callback != null) {
                    callback.onCompleted(image.a(), image.b());
                }
            }
        });
    }

    private static Point a(String text) {
        if (text == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("^(\\d+)x(\\d+)$");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String xText = matcher.group(1);
            String yText = matcher.group(2);
            return new Point(Integer.parseInt(xText), Integer.parseInt(yText));
        }
        return null;
    }
}

