/*
 * Decompiled with CFR 0.152.
 */
package jp.co.olympus.camerakit;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeoutException;
import jp.co.olympus.camerakit.OLYCamera;
import jp.co.olympus.camerakit.OLYCameraFileInfo;
import jp.co.olympus.camerakit.OLYCameraKitException;
import jp.co.olympus.camerakit.OLYCameraLog;
import jp.co.olympus.camerakit.h;
import jp.co.olympus.camerakit.internal.c;
import jp.co.olympus.camerakit.internal.d;
import jp.co.olympus.camerakit.internal.e;

public class OLYCameraPlaybackMaintenanceTrait {
    private OLYCamera.f a;

    protected OLYCameraPlaybackMaintenanceTrait(OLYCamera.f adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        if (!(adapter instanceof OLYCamera.f)) {
            throw new IllegalAccessError();
        }
        this.a = adapter;
    }

    public void attachGpsTagToDcfContents(final List<String> log, final OLYCamera.a callback) {
        OLYCameraLog.i("log=%s", log);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.a(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.a(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playmaintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.a(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (log == null || log.size() <= 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'log' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.a(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                long unusedCapacity;
                ArrayList<OLYCameraFileInfo> result = new ArrayList<OLYCameraFileInfo>();
                if (callback != null) {
                    OLYCamera.ProgressEvent e2 = new OLYCamera.ProgressEvent(0.0f, true);
                    callback.a(e2);
                    if (e2.a()) {
                        OLYCameraLog.w("Cancel attaching gps tag.", new Object[0]);
                        OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                        callback.a(theException);
                        return;
                    }
                }
                int divunit = 0;
                try {
                    divunit = OLYCameraPlaybackMaintenanceTrait.this.a.a(new OLYCamera.c<Integer, h>(){

                        @Override
                        public Integer a(h value) throws Exception {
                            return value.D(10.0);
                        }
                    });
                }
                catch (Exception e3) {
                    OLYCameraKitException theException = new OLYCameraKitException(e3);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.a(theException);
                    }
                    return;
                }
                if (divunit == 0) {
                    throw new AssertionError();
                }
                try {
                    unusedCapacity = OLYCameraPlaybackMaintenanceTrait.this.a.a(new OLYCamera.c<Long, h>(){

                        @Override
                        public Long a(h value) throws Exception {
                            return value.E(10.0);
                        }
                    });
                }
                catch (Exception e4) {
                    OLYCameraKitException theException = new OLYCameraKitException(e4);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.a(theException);
                    }
                    return;
                }
                long logSize = 0L;
                for (int li = 0; li <= log.size() - 1; ++li) {
                    String logRecord = (String)log.get(li);
                    if (logSize + (long)logRecord.getBytes(Charset.forName("UTF-8")).length < logSize) {
                        OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'log' is invalid.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.a(theException);
                        }
                    }
                    logSize += (long)logRecord.getBytes(Charset.forName("UTF-8")).length;
                }
                if (logSize > unusedCapacity) {
                    OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'log' is invalid.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.a(theException);
                    }
                    return;
                }
                int clen = log.size() / divunit;
                if (log.size() > clen * divunit) {
                    ++clen;
                }
                for (int ci = 0; ci < clen; ++ci) {
                    List<OLYCameraFileInfo> fileList;
                    int start = ci * divunit;
                    int length = ci == clen - 1 ? log.size() - ci * divunit : divunit;
                    final StringBuilder logdata = new StringBuilder();
                    for (int li = 0; li < length; ++li) {
                        logdata.append((String)log.get(li + start));
                    }
                    try {
                        fileList = OLYCameraPlaybackMaintenanceTrait.this.a.a(new OLYCamera.c<List<OLYCameraFileInfo>, h>(){

                            @Override
                            public List<OLYCameraFileInfo> a(h value) throws Exception {
                                return value.b(logdata.toString(), 10.0);
                            }
                        });
                    }
                    catch (Exception e5) {
                        OLYCameraKitException theException = new OLYCameraKitException(e5);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.a(theException);
                        }
                        return;
                    }
                    if (fileList == null) {
                        throw new AssertionError();
                    }
                    result.addAll(fileList);
                    if (callback == null) continue;
                    OLYCamera.ProgressEvent e6 = new OLYCamera.ProgressEvent((float)(ci + 1) / (float)clen, true);
                    callback.a(e6);
                    if (!e6.a()) continue;
                    OLYCameraLog.w("Cancel attaching gps tag.", new Object[0]);
                    OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                    callback.a(theException);
                    return;
                }
                if (callback != null) {
                    callback.a(result);
                }
            }
        });
    }

    public void writeCameraGpsLog(final Date date, final List<String> log, final boolean append, final OLYCamera.ProgressCallback callback) {
        OLYCameraLog.i("date=%s, log=%s, append=%s", date, log, String.valueOf(append));
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playmaintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (date == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'date' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (log == null || log.size() <= 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'log' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                long unusedCapacity;
                boolean anAppend = append;
                if (callback != null) {
                    OLYCamera.ProgressEvent e2 = new OLYCamera.ProgressEvent(0.0f, true);
                    callback.onProgress(e2);
                    if (e2.a()) {
                        OLYCameraLog.w("Cancel attaching gps tag.", new Object[0]);
                        OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                        callback.onErrorOccurred(theException);
                        return;
                    }
                }
                int divunit = 0;
                try {
                    divunit = OLYCameraPlaybackMaintenanceTrait.this.a.a(new OLYCamera.c<Integer, h>(){

                        @Override
                        public Integer a(h value) throws Exception {
                            return value.D(10.0);
                        }
                    });
                }
                catch (Exception e3) {
                    OLYCameraKitException theException = new OLYCameraKitException(e3);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (divunit == 0) {
                    throw new AssertionError();
                }
                try {
                    unusedCapacity = OLYCameraPlaybackMaintenanceTrait.this.a.a(new OLYCamera.c<Long, h>(){

                        @Override
                        public Long a(h value) throws Exception {
                            return value.E(10.0);
                        }
                    });
                }
                catch (Exception e4) {
                    OLYCameraKitException theException = new OLYCameraKitException(e4);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                long logSize = 0L;
                for (int li = 0; li <= log.size() - 1; ++li) {
                    String logRecord = (String)log.get(li);
                    if (logSize + (long)logRecord.getBytes(Charset.forName("UTF-8")).length < logSize) {
                        OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'log' is invalid.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                    }
                    logSize += (long)logRecord.getBytes(Charset.forName("UTF-8")).length;
                }
                if (logSize > unusedCapacity) {
                    OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'log' is invalid.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                int clen = log.size() / divunit;
                if (log.size() > clen * divunit) {
                    ++clen;
                }
                for (int ci = 0; ci < clen; ++ci) {
                    int start = ci * divunit;
                    int length = ci == clen - 1 ? log.size() - ci * divunit : divunit;
                    final StringBuilder logdata = new StringBuilder();
                    for (int li = 0; li < length; ++li) {
                        logdata.append((String)log.get(li + start));
                    }
                    try {
                        final boolean f_anAppend = anAppend;
                        OLYCameraPlaybackMaintenanceTrait.this.a.a(new OLYCamera.c<Void, h>(){

                            @Override
                            public Void a(h value) throws Exception {
                                value.a(logdata.toString(), f_anAppend, date, TimeZone.getDefault(), 10.0);
                                return null;
                            }
                        });
                    }
                    catch (Exception e5) {
                        OLYCameraLog.e("Could not attach.", new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(new OLYCameraKitException(e5));
                        }
                        return;
                    }
                    if (callback != null) {
                        OLYCamera.ProgressEvent e6 = new OLYCamera.ProgressEvent((float)(ci + 1) / (float)clen, true);
                        callback.onProgress(e6);
                        if (e6.a()) {
                            OLYCameraLog.w("Cancel attaching gps tag.", new Object[0]);
                            OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                            callback.onErrorOccurred(theException);
                            return;
                        }
                    }
                    anAppend = true;
                }
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public void protectContent(final String path) throws OLYCameraKitException {
        String result;
        OLYCameraLog.i("path=%s", path);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playmaintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (path == null || path.length() <= 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'log' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            result = this.a.a(new OLYCamera.c<String, h>(){

                @Override
                public String a(h value) throws Exception {
                    return value.c("set", path, 10.0);
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!"OK".equals(result)) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void unprotectContent(final String path) throws OLYCameraKitException {
        String result;
        OLYCameraLog.i("path=%s", path);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playmaintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (path == null || path.length() <= 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'log' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            result = this.a.a(new OLYCamera.c<String, h>(){

                @Override
                public String a(h value) throws Exception {
                    return value.c("release", path, 10.0);
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!"OK".equals(result)) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void unprotectAllContents(final OLYCamera.ProgressCallback callback) {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playmaintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                String result;
                e eventQueue = OLYCameraPlaybackMaintenanceTrait.this.a.d();
                eventQueue.a();
                try {
                    result = OLYCameraPlaybackMaintenanceTrait.this.a.a(new OLYCamera.c<String, h>(){

                        @Override
                        public String a(h value) throws Exception {
                            return value.V(10.0);
                        }
                    });
                }
                catch (Exception e2) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (!"OK".equals(result)) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                long timeoutInMillis = 180000L;
                c event = null;
                try {
                    event = eventQueue.a(timeoutInMillis);
                    while (event != null && event.a() != c.a.z) {
                        if (event != null && event.a() == c.a.m) {
                            float progress = ((d.f)event.c()).a();
                            if (callback != null) {
                                callback.onProgress(new OLYCamera.ProgressEvent(progress, false));
                            }
                        }
                        event = eventQueue.a(timeoutInMillis);
                    }
                }
                catch (TimeoutException e3) {
                    event = null;
                }
                if (event == null) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(new OLYCameraKitException(theException));
                    }
                    return;
                }
                eventQueue.b();
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public void eraseDcfContents(final String path) throws OLYCameraKitException {
        String result;
        OLYCameraLog.i("path=%s", path);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playmaintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (path == null || path.length() <= 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'log' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            result = this.a.a(new OLYCamera.c<String, h>(){

                @Override
                public String a(h value) throws Exception {
                    return value.a(path, 10.0);
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!"OK".equals(result)) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void eraseAllContents(final OLYCamera.ProgressCallback callback) {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playmaintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                String result;
                e eventQueue = OLYCameraPlaybackMaintenanceTrait.this.a.e();
                eventQueue.a();
                try {
                    result = OLYCameraPlaybackMaintenanceTrait.this.a.a(new OLYCamera.c<String, h>(){

                        @Override
                        public String a(h value) throws Exception {
                            return value.w(10.0);
                        }
                    });
                }
                catch (Exception e2) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (!"OK".equals(result)) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                long timeoutInMillis = 180000L;
                c event = null;
                try {
                    event = eventQueue.a(timeoutInMillis);
                    while (event != null && event.a() != c.a.D) {
                        if (event != null && event.a() == c.a.m) {
                            float progress = ((d.f)event.c()).a();
                            if (callback != null) {
                                callback.onProgress(new OLYCamera.ProgressEvent(progress, false));
                            }
                        }
                        event = eventQueue.a(timeoutInMillis);
                    }
                }
                catch (TimeoutException e3) {
                    event = null;
                }
                if (event == null) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(new OLYCameraKitException(theException));
                    }
                    return;
                }
                if (event.c() != null) {
                    String erasingAllDataFromCardResult = ((d.c)event.c()).a();
                    if (!"ok".equals(erasingAllDataFromCardResult)) {
                        eventQueue.b();
                        OLYCameraKitException theException = new OLYCameraKitException("Erasing all contents failed.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                } else {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                eventQueue.b();
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public void formatMedia(final OLYCamera.ProgressCallback callback) {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playmaintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                String result;
                e eventQueue = OLYCameraPlaybackMaintenanceTrait.this.a.f();
                eventQueue.a();
                try {
                    result = OLYCameraPlaybackMaintenanceTrait.this.a.a(new OLYCamera.c<String, h>(){

                        @Override
                        public String a(h value) throws Exception {
                            return value.v(30.0);
                        }
                    });
                }
                catch (Exception e2) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (!"OK".equals(result)) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera has rejected the operation.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                long timeoutInMillis = 180000L;
                c event = null;
                try {
                    event = eventQueue.a(timeoutInMillis);
                    while (event != null && event.a() != c.a.C) {
                        if (event != null && event.a() == c.a.m) {
                            float progress = ((d.f)event.c()).a();
                            if (callback != null) {
                                callback.onProgress(new OLYCamera.ProgressEvent(progress, false));
                            }
                        }
                        event = eventQueue.a(timeoutInMillis);
                    }
                }
                catch (TimeoutException e3) {
                    event = null;
                }
                if (event == null) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(new OLYCameraKitException(theException));
                    }
                    return;
                }
                if (event.c() != null) {
                    String formatingCardExtensionResult = ((d.d)event.c()).a();
                    if (!"ok".equals(formatingCardExtensionResult)) {
                        eventQueue.b();
                        OLYCameraKitException theException = new OLYCameraKitException("Formatting a card failed.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                } else {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                eventQueue.b();
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }
}

