// unicode.h

#ifndef UNICODE_H
#define UNICODE_H

/*---------------------------------------------------------------------------
  Shift_JISの一文字をUCS2に変換する
    sjis: Shift_JIS
    return: UCS2
---------------------------------------------------------------------------*/
u16 sjis_utf16(u16 sjis);

/*---------------------------------------------------------------------------
  Shift_JIS文字列をUTF-8Nに変換する
    sjis: Shift_JIS文字列へのポインタ
    utf: UTF-8N文字列へのポインタ
    return: 変換した文字数
---------------------------------------------------------------------------*/
u32 sjis_to_utf8(void *utf, const void *sjis);

/*---------------------------------------------------------------------------
  Shift_JIS文字列をUTF-16に変換する
    sjis: Shift_JIS文字列へのポインタ
    utf16: UTF-16文字列へのポインタ
    return: 変換した文字数
---------------------------------------------------------------------------*/
u32 sjis_to_utf16(void *utf16, const void *sjis);

/*---------------------------------------------------------------------------
  UTF-16の一文字をShift_JISに変換する
    utf16: UTF-16
    return: Shift_JIS
---------------------------------------------------------------------------*/
u16 utf16_sjis(u16 utf16);

/*---------------------------------------------------------------------------
  UTF-16文字列をShift_JISに変換する
    sjis: Shift_JIS文字列へのポインタ
    utf16: UTF-16文字列へのポインタ
    return: 変換した文字数
---------------------------------------------------------------------------*/
u32 utf16_to_sjis(void *sjis, const void *utf16);

#endif
