#ifndef EMU_MAIN_H
#define EMU_MAIN_H
//#include "nes/types.h"

enum {
	EMU_SPEED_NORMAL,
	EMU_SPEED_MODE1,
	EMU_SPEED_MODE2
};

// NES init
void PSPEMU_NES_Init(void);
// w肵ԍ̃Xe[gĂяo
u8 PSPEMU_LoadState(u32 ulNum);
// w肵ԍɃXe[gۑ
u8 PSPEMU_SaveState(u32 ulNum);
// w肵ԍɃXe[g폜
u8 PSPEMU_DeleteState(u32 ulNum);
// Screen shotۑ
u8 PSPEMU_SaveScreenShot(void);

// j[ƂĂяo
void PSPEMU_Freeze(void);

// FreeseďIĂяo
void PSPEMU_Thaw(void);

// get disk side number
u8 PSPEMU_GetDiskSideNum(void);

// set disk side
void PSPEMU_SetDiskSide(u8 side);

// get disk side
u8 PSPEMU_GetDiskSide(void);

// apply game genie code
int PSPEMU_ApplyGameGenie(const char *pszFile);

// Apply graphics config
void PSPEMU_ApplyGraphicsConfig(void);

// Apply sound config
void PSPEMU_ApplySoundConfig(void);

// Save ram
void PSPEMU_SaveRAM(void);

// ݂̐ݒł̃t[[gݒs(internal)
void PSPEMU_SetFrameSpeed(void);

// G~C
void PSPEMU_DoFrame(void);

#endif
