#pragma once

#include <QtCore>
#include <QHostAddress>
namespace structures{
	class settings{
	public:
		settings();
		settings(const QString &name,const QHostAddress address=QHostAddress(QHostAddress::Any),const quint16 port=10630,const bool noloadMember=false);
		void setName(const QString &name),
			 setIPAddr(const QHostAddress &address),
			 setPort(const quint16 port),
			 setFileName(const QString &name),
			 setNoloadMemberList(const bool yesno);
		QString name()const;
		QHostAddress bindingAddr()const;
		quint16 port()const;
		bool noloadMemberList()const;
		friend QDataStream &operator<<(QDataStream &out,const settings &value){
			out<<value._port<<value._bindingAddr<<value._name<<value._noloadmember;
			return out;
		}
		friend QDataStream &operator>>(QDataStream &in,settings &value){
			in>>value._port>>value._bindingAddr>>value._name<<value._noloadmember;
			return in;
		}
	private:
		QString _name;
		QHostAddress _bindingAddr;
		quint16 _port;
		bool _noloadmember;
	};
}
