#pragma once
#include <QtNetwork>
//By default, timeout (i.e. connection timeout,sending timeout, and receiving timeout) is 10000 ms. which is 10 sec.
#define TIMEOUT 10000
namespace network{
	class tcpClient:virtual public QTcpSocket{
		Q_OBJECT
	public:
		tcpClient(quint64 buffersize,const QString &senderName,QObject *parent=NULL);
		tcpClient &operator<<(const QString &),
				  &operator<<(QFile &);
		quint64 timeout() const;
		void timeout(const quint64);
	protected:
		void disconnectFromHostImplementation();
	signals:
		void sentData();
	private slots:
		void data_available();
	private:
		quint64 buffer_size,timeout_time;
		bool check_connection_and_wait_connected(),
			 check_byte_written_and_wait_written(),
			 check_and_wait_byte_available();
		bool want_disconnect;
		const QString *senderName;
	};
}
