#include "tcpserver.h"
#include <cstring>
#include "../structures/header.h"

using namespace network;
using namespace enc_hash;
using namespace structures;
using namespace std;
tcpServer::tcpServer(quint64 buffersize, QObject *parent):QTcpServer(parent){this->buffersize=buffersize;}
void tcpServer::incomingConnection(int handle){
	serverSocket *socket=new serverSocket(this->buffersize,this);

	if(!socket->setSocketDescriptor(handle)){
		emit this->socket_error(*socket);
		delete socket;
		return;
	}

	if(emit this->pending(*socket))
		emit this->newConnection();
	else socket->disconnectFromHost();
}

serverSocket::serverSocket(quint64 buffersize, QObject *parent):QTcpSocket(parent){
	this->buffer_size=buffersize;
	this->canceled=false;
	connect(this,SIGNAL(disconnected()),SLOT(deleteLataer()));
	connect(this,SIGNAL(readyRead()),SLOT(read_data()));
}
void serverSocket::read_data(){
	switch(data){
		case serverSocket::headsize:this->size_event();		break;
		case serverSocket::header:  this->header_event();	break;
		case serverSocket::data:	this->data_event();		break;
	}
}
void serverSocket::size_event(){
	if(this->bytesAvailable()<2) return;
	char size_buf[2];
	this->read(size_buf,sizeof(size_buf));
	memcpy(&this->header_size,size_buf,
		   (sizeof(quint16)>sizeof(char))?sizeof(quint16):sizeof(size_buf)
		   );
	this->event=serverSocket::header;
}
void serverSocket::header_event(){
	if(this->bytesAvailable()<this->header_size) return;
	else{
		QByteArray data=this->read(this->header_size);
		QDataStream datastream(data);
		datastream>>this->head_data;
		if(this->head_data==structures::header()){
			this->abort_receive(serverSocket::header_invalid);
			return;
		}
		if(!this->head_data.fileName().isEmpty()){
			this->where_to_save=(emit this->file_pending((*this)));
			if(this->where_to_save.isEmpty()){
				this->write(QByteArray(1,0x00));
				emit this->receive_aborted((*this),serverSocket::empty_filename_specified);
				this->disconnectFromHost();
				return;
			}
		}
	}
	this->event=serverSocket::data;
}
void serverSocket::data_event(){
	if(this->bytesAvailable()<this->buffer_size) return;

	quint64 final_readsize=this->head_data.datasize()%this->buffer_size,
	read_count=(this->head_data.datasize()-final_readsize)/this->buffer_size;

	if(this->head_data.fileName().isEmpty()){
		QByteArray msg;
		for(quint64 count=0;count<read_count;count++){
			if(this->check_canceled_then_abort())return;
			msg+=this->read(this->buffer_size);
		}
		this->check_canceled_then_abort();
		msg+=this->read(final_readsize);

		rmd6 generator;
		if(this->head_data.ripemd160()==generator.compute_hash(msg))
			emit this->msg_received((*this),QString::fromUtf8(msg.data()));
		else emit this->data_broken((*this));
	}else{
		streamopen:
		if(this->where_to_save.isEmpty()){
			this->abort_receive(serverSocket::empty_filename_specified);
			return;
		}
		QFile file(this->where_to_save,this);
		if(!file.open(QIODevice::Truncate|QIODevice::WriteOnly)){
			this->where_to_save=emit this->fileStream_openFailed((*this),file.error(),file.errorString());
			goto streamopen;
		}
		for(quint64 count=0;count<read_count;count++){
			if(this->check_canceled_then_abort())return;
			file.write(this->read(this->buffer_size));
			emit this->file_receive_progress(file.pos(),(*this));
		}
		this->check_canceled_then_abort();
		file.write(this->read(final_readsize));
		emit this->file_receive_progress(file.pos(),(*this));
		file.close();

		rmd6 generator;
		if(this->head_data.ripemd160()==generator.compute_hash(file))
			emit this->file_saved((*this));
		else emit this->file_broken((*this));
	}
	this->disconnectFromHost();
}
bool serverSocket::check_canceled_then_abort(){
	if(this->canceled){
		this->abort_receive(serverSocket::user);
		return true;
	}
	return false;
}
void serverSocket::abort_receive(aborted_reason reason){
	this->write(QByteArray(1,0x00));
	emit this->receive_aborted((*this),reason);
	this->disconnectFromHost();
}
void serverSocket::cancel(){this->canceled=true;}
QString serverSocket::path_to_save() const{return this->where_to_save;}
header serverSocket::header_data() const{return this->head_data;}
