#include "editdelegate.h"
#include "memberlist.h"

#define AddressIndex 1
#define NameIndex 0

MemberList::MemberList(QWidget *parent):QTableWidget(parent){
	this->verticalHeader()->setVisible(false);
	this->verticalHeader()->setDefaultSectionSize(15);
	this->verticalHeader()->setDefaultSectionSize(15);
	this->setColumnCount(2);
	QStringList labels;
	labels<<tr("Name")<<tr("IPAddress");
	this->setHorizontalHeaderLabels(labels);
	this->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
	this->horizontalHeader()->setVisible(true);
	this->setItemDelegateForColumn(1,new MemberListEditDelegate(this));
}
QList<AddressAndPort> MemberList::addressPortList() const{
	QList<AddressAndPort> ret;
	for(int row=0;row<this->rowCount();row++){
		QStringList address_port_str=this->item(row,AddressIndex)->text().split(":");
		if(address_port_str.size()<2||address_port_str[1].isEmpty()) address_port_str[1]=QString("%1").arg(default_port);
		AddressAndPort address_port(QHostAddress(address_port_str[0]),address_port_str[1].isEmpty()?default_port:address_port_str[1].toUShort());
		ret<<address_port;
	}
	return ret;
}
QStringList MemberList::name() const{
	QStringList ret;
	for(int row=0;row<this->rowCount();row++) ret<<this->item(row,NameIndex)->text();
	return ret;
}
void MemberList::remove_selected(){
	while(this->selectedItems().size()>0&&this->selectedRanges()[0].rowCount()>0)
		this->removeRow(this->selectedRanges()[0].topRow());
}
void MemberList::remove_all_contents(){while(this->rowCount()>0) this->removeRow(0);}
void MemberList::keyReleaseEvent(QKeyEvent *event){
	if(event->matches(QKeySequence::Delete)){
		remove_selected();
		event->ignore();
	}else event->accept();
}
