#pragma once
#include <QtGui>
class RtfEditor:virtual public QWidget{
	Q_OBJECT
	Q_PROPERTY(QString html READ html WRITE html)
	Q_PROPERTY(QString plain READ plain WRITE plain)
public:
	RtfEditor(QWidget *parent=NULL);
public:
	QString html() const, plain() const;
	void html(const QString &),plain(const QString &);
private slots:
	void selectionChnged();
	void makeBold(bool);
	void makeItalic(bool);
	void makeColor(bool);
	void makeLink(bool);
	void setLink(const QString &link);
signals:
	void invalidLink(const QString &link);
	void sendTriggered();
private:
	enum style{Bold,Italic};
	void makeStyle(const style s,bool on);
	//When this widget is focused,To have this->editor focused is needed for convenience.
	void focusInEvent(QFocusEvent *);
	void keyPressEvent(QKeyEvent *);
	QColor defaltTextColor;
	QPalette colorset;
	QAction *bold,*italic,*link,*color;
	QToolBar *toolbar;
	QTextEdit *editor;
	QVBoxLayout *layout;
};
